/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.sampling;

import java.nio.ByteOrder;
import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.memory.NativeMemory;
import shade.com.yahoo.memory.UnsafeUtil;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.ResizeFactor;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.sampling.ReservoirSize;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BIT = 6;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int RESERVOIR_SIZE_SHORT = 4;
    static final int RESERVOIR_SIZE_INT = 4;
    static final int SERDE_ID_SHORT = 6;
    static final int ITEMS_SEEN_LONG = 8;
    static final int MAX_K_SIZE_INT = 4;
    static final int EMPTY_FLAG_MASK = 4;
    static final int SER_VER = 2;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private PreambleUtil() {
    }

    public static String preambleToString(byte[] byteArr) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.preambleToString(mem);
    }

    public static String preambleToString(Memory mem) {
        int preLongs = PreambleUtil.getAndCheckPreLongs(mem);
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        Family family = Family.idToFamily(PreambleUtil.extractFamilyID(memObj, memAddr));
        switch (family) {
            case RESERVOIR: {
                return PreambleUtil.sketchPreambleToString(mem, family, preLongs);
            }
            case RESERVOIR_UNION: {
                return PreambleUtil.unionPreambleToString(mem, family, preLongs);
            }
        }
        throw new SketchesArgumentException("Inspecting preamble with Sampling family's PreambleUtil with object of family " + family.getFamilyName());
    }

    private static String sketchPreambleToString(Memory mem, Family family, int preLongs) {
        int resSize;
        boolean isEmpty;
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(memObj, memAddr));
        int serVer = PreambleUtil.extractSerVer(memObj, memAddr);
        int flags = PreambleUtil.extractFlags(memObj, memAddr);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean bl = isEmpty = (flags & 4) > 0;
        if (serVer == 1) {
            short encResSize = PreambleUtil.extractEncodedReservoirSize(memObj, memAddr);
            resSize = ReservoirSize.decodeValue(encResSize);
        } else {
            resSize = PreambleUtil.extractReservoirSize(memObj, memAddr);
        }
        long itemsSeen = 0L;
        if (!isEmpty) {
            itemsSeen = PreambleUtil.extractItemsSeenCount(memObj, memAddr);
        }
        long dataBytes = mem.getCapacity() - (long)(preLongs << 3);
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### END ").append(family.getFamilyName().toUpperCase()).append(" PREAMBLE SUMMARY").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  0: ResizeFactor         : ").append(rf.toString()).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(family.toString()).append(Util.LS).append("Byte  3: Flags Field          : ").append(flagsStr).append(Util.LS).append("  EMPTY                       : ").append(isEmpty).append(Util.LS).append("Bytes  4-7: Sketch Size (k)   : ").append(resSize).append(Util.LS);
        if (!isEmpty) {
            sb.append("Bytes 8-13: Items Seen (n)    : ").append(itemsSeen).append(Util.LS);
        }
        sb.append("TOTAL Sketch Bytes            : ").append(mem.getCapacity()).append(Util.LS).append("  Preamble Bytes              : ").append(preLongs << 3).append(Util.LS).append("  Data Bytes                  : ").append(dataBytes).append(Util.LS).append("### END ").append(family.getFamilyName().toUpperCase()).append(" PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    private static String unionPreambleToString(Memory mem, Family family, int preLongs) {
        int resSize;
        boolean isEmpty;
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(memObj, memAddr));
        int serVer = PreambleUtil.extractSerVer(memObj, memAddr);
        int flags = PreambleUtil.extractFlags(memObj, memAddr);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean bl = isEmpty = (flags & 4) > 0;
        if (serVer == 1) {
            short encResSize = PreambleUtil.extractEncodedReservoirSize(memObj, memAddr);
            resSize = ReservoirSize.decodeValue(encResSize);
        } else {
            resSize = PreambleUtil.extractReservoirSize(memObj, memAddr);
        }
        long dataBytes = mem.getCapacity() - (long)(preLongs << 3);
        return Util.LS + "### END " + family.getFamilyName().toUpperCase() + " PREAMBLE SUMMARY" + Util.LS + "Byte  0: Preamble Longs           : " + preLongs + Util.LS + "Byte  0: ResizeFactor             : " + rf.toString() + Util.LS + "Byte  1: Serialization Version    : " + serVer + Util.LS + "Byte  2: Family                   : " + family.toString() + Util.LS + "Byte  3: Flags Field              : " + flagsStr + Util.LS + "  EMPTY                           : " + isEmpty + Util.LS + "Bytes  4-7: Max Sketch Size (maxK): " + resSize + Util.LS + "TOTAL Sketch Bytes                : " + mem.getCapacity() + Util.LS + "  Preamble Bytes                  : " + (preLongs << 3) + Util.LS + "  Sketch Bytes                    : " + dataBytes + Util.LS + "### END " + family.getFamilyName().toUpperCase() + " PREAMBLE SUMMARY" + Util.LS;
    }

    static int extractPreLongs(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getByte(memObj, memAddr + 0L) & 0x3F;
    }

    static int extractResizeFactor(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getByte(memObj, memAddr + 0L) >>> 6 & 3;
    }

    static int extractSerVer(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getByte(memObj, memAddr + 1L) & 0xFF;
    }

    static int extractFamilyID(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getByte(memObj, memAddr + 2L) & 0xFF;
    }

    static int extractFlags(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getByte(memObj, memAddr + 3L) & 0xFF;
    }

    static short extractEncodedReservoirSize(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getShort(memObj, memAddr + 4L);
    }

    static int extractReservoirSize(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getInt(memObj, memAddr + 4L);
    }

    static int extractMaxK(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getInt(memObj, memAddr + 4L);
    }

    @Deprecated
    static short extractSerDeId(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getShort(memObj, memAddr + 6L);
    }

    static long extractItemsSeenCount(Object memObj, long memAddr) {
        return UnsafeUtil.unsafe.getLong(memObj, memAddr + 8L);
    }

    static void insertPreLongs(Object memObj, long memAddr, int preLongs) {
        byte curByte = UnsafeUtil.unsafe.getByte(memObj, memAddr + 0L);
        int mask = 63;
        byte newByte = (byte)(preLongs & 0x3F | 0xFFFFFFC0 & curByte);
        UnsafeUtil.unsafe.putByte(memObj, memAddr + 0L, newByte);
    }

    static void insertLgResizeFactor(Object memObj, long memAddr, int rf) {
        byte curByte = UnsafeUtil.unsafe.getByte(memObj, memAddr + 0L);
        int shift = 6;
        int mask = 3;
        byte newByte = (byte)((rf & 3) << 6 | 0xFFFFFF3F & curByte);
        UnsafeUtil.unsafe.putByte(memObj, memAddr + 0L, newByte);
    }

    static void insertSerVer(Object memObj, long memAddr, int serVer) {
        UnsafeUtil.unsafe.putByte(memObj, memAddr + 1L, (byte)serVer);
    }

    static void insertFamilyID(Object memObj, long memAddr, int famId) {
        UnsafeUtil.unsafe.putByte(memObj, memAddr + 2L, (byte)famId);
    }

    static void insertFlags(Object memObj, long memAddr, int flags) {
        UnsafeUtil.unsafe.putByte(memObj, memAddr + 3L, (byte)flags);
    }

    static void insertReservoirSize(Object memObj, long memAddr, int k) {
        UnsafeUtil.unsafe.putInt(memObj, memAddr + 4L, k);
    }

    static void insertMaxK(Object memObj, long memAddr, int maxK) {
        PreambleUtil.insertReservoirSize(memObj, memAddr, maxK);
    }

    @Deprecated
    static void insertSerDeId(Object memObj, long memAddr, short serDeId) {
        UnsafeUtil.unsafe.putShort(memObj, memAddr + 6L, serDeId);
    }

    static void insertItemsSeenCount(Object memObj, long memAddr, long totalSeen) {
        UnsafeUtil.unsafe.putLong(memObj, memAddr + 8L, totalSeen);
    }

    static int getAndCheckPreLongs(Memory mem) {
        int preLongs;
        int required;
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        long cap = mem.getCapacity();
        if (cap < 8L) {
            PreambleUtil.throwNotBigEnough(cap, 8);
        }
        if (cap < (long)(required = Math.max((preLongs = PreambleUtil.extractPreLongs(memObj, memAddr)) << 3, 8))) {
            PreambleUtil.throwNotBigEnough(cap, required);
        }
        return preLongs;
    }

    private static void throwNotBigEnough(long cap, int required) {
        throw new SketchesArgumentException("Possible Corruption: Size of byte array or Memory not large enough: Size: " + cap + ", Required: " + required);
    }
}

