/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.theta;

import java.util.Arrays;
import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.memory.NativeMemory;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.HashOperations;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.SketchesStateException;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.theta.CompactSketch;
import shade.com.yahoo.sketches.theta.Intersection;
import shade.com.yahoo.sketches.theta.PreambleUtil;
import shade.com.yahoo.sketches.theta.SetOperation;
import shade.com.yahoo.sketches.theta.Sketch;

final class IntersectionImpl
extends SetOperation
implements Intersection {
    private final short seedHash_;
    private final Memory mem_;
    private int lgArrLongs_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private long[] hashTable_ = null;
    private int maxLgArrLongs_ = 0;

    private IntersectionImpl(Memory mem, long seed, boolean newMem) {
        this.mem_ = mem;
        if (mem != null) {
            if (newMem) {
                this.seedHash_ = IntersectionImpl.computeSeedHash(seed);
                this.mem_.putShort(6L, this.seedHash_);
            } else {
                this.seedHash_ = this.mem_.getShort(6L);
                Util.checkSeedHashes(this.seedHash_, IntersectionImpl.computeSeedHash(seed));
            }
        } else {
            this.seedHash_ = IntersectionImpl.computeSeedHash(seed);
        }
    }

    static IntersectionImpl initNewHeapInstance(long seed) {
        IntersectionImpl impl = new IntersectionImpl(null, seed, false);
        impl.lgArrLongs_ = 0;
        impl.curCount_ = -1;
        impl.thetaLong_ = Long.MAX_VALUE;
        impl.empty_ = false;
        impl.hashTable_ = null;
        return impl;
    }

    static IntersectionImpl heapifyInstance(Memory srcMem, long seed) {
        boolean empty;
        long thetaLong;
        int curCount;
        int flags;
        int lgArrLongs;
        int famID;
        int serVer;
        int preLongsMem;
        IntersectionImpl impl = new IntersectionImpl(null, seed, false);
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongsMem = srcMem.getByte(0L) & 0x3F;
            serVer = srcMem.getByte(1L) & 0xFF;
            famID = srcMem.getByte(2L) & 0xFF;
            lgArrLongs = srcMem.getByte(4L) & 0xFF;
            flags = srcMem.getByte(5L) & 0xFF;
            curCount = srcMem.getInt(8L);
            thetaLong = srcMem.getLong(16L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongsMem = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            famID = PreambleUtil.extractFamilyID(memObj, memAdd);
            lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            curCount = PreambleUtil.extractCurCount(memObj, memAdd);
            thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
        }
        boolean bl = empty = (flags & 4) > 0;
        if (preLongsMem != 3) {
            throw new SketchesArgumentException("Memory PreambleLongs must equal 3: " + preLongsMem);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Serialization Version must equal 3");
        }
        Family.INTERSECTION.checkFamilyID(famID);
        if (empty && curCount != 0) {
            throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + empty + "," + curCount);
        }
        impl.lgArrLongs_ = lgArrLongs;
        impl.curCount_ = curCount;
        impl.thetaLong_ = thetaLong;
        impl.empty_ = empty;
        if (!empty && curCount > 0) {
            impl.hashTable_ = new long[1 << lgArrLongs];
            srcMem.getLongArray(24L, impl.hashTable_, 0, 1 << lgArrLongs);
        }
        return impl;
    }

    static IntersectionImpl initNewDirectInstance(long seed, Memory dstMem) {
        IntersectionImpl impl = new IntersectionImpl(dstMem, seed, true);
        Object memObj = dstMem.array();
        long memAdd = dstMem.getCumulativeOffset(0L);
        PreambleUtil.insertPreLongs(memObj, memAdd, 3);
        PreambleUtil.insertSerVer(memObj, memAdd, 3);
        PreambleUtil.insertFamilyID(memObj, memAdd, Family.INTERSECTION.getID());
        PreambleUtil.insertLgArrLongs(memObj, memAdd, 5);
        PreambleUtil.insertFlags(memObj, memAdd, 0);
        PreambleUtil.insertCurCount(memObj, memAdd, -1);
        PreambleUtil.insertP(memObj, memAdd, 1.0f);
        PreambleUtil.insertThetaLong(memObj, memAdd, Long.MAX_VALUE);
        impl.lgArrLongs_ = 5;
        impl.curCount_ = -1;
        impl.thetaLong_ = Long.MAX_VALUE;
        impl.empty_ = false;
        impl.maxLgArrLongs_ = IntersectionImpl.checkMaxLgArrLongs(dstMem);
        return impl;
    }

    static IntersectionImpl wrapInstance(Memory srcMem, long seed) {
        boolean empty;
        long thetaLong;
        int curCount;
        int flags;
        int lgArrLongs;
        int famID;
        int serVer;
        int preLongsMem;
        IntersectionImpl impl = new IntersectionImpl(srcMem, seed, false);
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            preLongsMem = srcMem.getByte(0L) & 0x3F;
            serVer = srcMem.getByte(1L) & 0xFF;
            famID = srcMem.getByte(2L) & 0xFF;
            lgArrLongs = srcMem.getByte(4L) & 0xFF;
            flags = srcMem.getByte(5L) & 0xFF;
            curCount = srcMem.getInt(8L);
            thetaLong = srcMem.getLong(16L);
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongsMem = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            famID = PreambleUtil.extractFamilyID(memObj, memAdd);
            lgArrLongs = PreambleUtil.extractLgArrLongs(memObj, memAdd);
            flags = PreambleUtil.extractFlags(memObj, memAdd);
            curCount = PreambleUtil.extractCurCount(memObj, memAdd);
            thetaLong = PreambleUtil.extractThetaLong(memObj, memAdd);
        }
        boolean bl = empty = (flags & 4) > 0;
        if (preLongsMem != 3) {
            throw new SketchesArgumentException("Memory PreambleLongs must equal 3: " + preLongsMem);
        }
        if (serVer != 3) {
            throw new SketchesArgumentException("Serialization Version must equal 3");
        }
        Family.INTERSECTION.checkFamilyID(famID);
        if (empty && curCount != 0) {
            throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + empty + "," + curCount);
        }
        impl.lgArrLongs_ = lgArrLongs;
        impl.curCount_ = curCount;
        impl.thetaLong_ = thetaLong;
        impl.empty_ = empty;
        impl.maxLgArrLongs_ = IntersectionImpl.checkMaxLgArrLongs(srcMem);
        return impl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Sketch sketchIn) {
        long memAdd;
        boolean firstCall = this.curCount_ < 0;
        Object memObj = this.mem_ != null ? this.mem_.array() : null;
        long l = memAdd = this.mem_ != null ? this.mem_.getCumulativeOffset(0L) : 0L;
        if (sketchIn == null) {
            this.empty_ = true;
            this.thetaLong_ = firstCall ? Long.MAX_VALUE : this.thetaLong_;
            this.curCount_ = 0;
            if (this.mem_ == null) return;
            PreambleUtil.setEmpty(memObj, memAdd);
            PreambleUtil.insertThetaLong(memObj, memAdd, this.thetaLong_);
            PreambleUtil.insertCurCount(memObj, memAdd, 0);
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
        boolean bl = this.empty_ = this.empty_ || sketchIn.isEmpty();
        if (this.mem_ != null) {
            PreambleUtil.insertThetaLong(memObj, memAdd, this.thetaLong_);
            if (this.empty_) {
                PreambleUtil.setEmpty(memObj, memAdd);
            } else {
                PreambleUtil.clearEmpty(memObj, memAdd);
            }
        }
        int sketchInEntries = sketchIn.getRetainedEntries(true);
        if (this.curCount_ == 0 || sketchInEntries == 0) {
            this.curCount_ = 0;
            if (this.mem_ != null) {
                PreambleUtil.insertCurCount(memObj, memAdd, 0);
            }
            this.hashTable_ = null;
            return;
        } else if (firstCall) {
            this.curCount_ = sketchIn.getRetainedEntries(true);
            int requiredLgArrLongs = IntersectionImpl.computeMinLgArrLongsFromCount(this.curCount_);
            int priorLgArrLongs = this.lgArrLongs_;
            this.lgArrLongs_ = requiredLgArrLongs;
            if (this.mem_ != null) {
                PreambleUtil.insertCurCount(memObj, memAdd, this.curCount_);
                PreambleUtil.insertLgArrLongs(memObj, memAdd, this.lgArrLongs_);
                if (requiredLgArrLongs > this.maxLgArrLongs_) throw new SketchesArgumentException("Insufficient dstMem hash table space: " + (1 << requiredLgArrLongs) + " > " + (1 << priorLgArrLongs));
                this.mem_.clear(24L, 8 << this.lgArrLongs_);
            } else {
                this.hashTable_ = new long[1 << this.lgArrLongs_];
            }
            this.moveDataToTgt(sketchIn.getCache(), this.curCount_);
            return;
        } else {
            this.performIntersect(sketchIn);
        }
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        long[] hashTable;
        if (this.curCount_ < 0) {
            throw new SketchesStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        if (this.mem_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            this.mem_.getLongArray(24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] compactCacheR = CompactSketch.compactCachePart(hashTable, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public boolean hasResult() {
        return this.mem_ != null ? this.mem_.getInt(8L) >= 0 : this.curCount_ >= 0;
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[24 + dataBytes];
        if (this.mem_ != null) {
            this.mem_.getByteArray(0L, byteArrOut, 0, 24 + dataBytes);
        } else {
            NativeMemory memOut = new NativeMemory(byteArrOut);
            memOut.putByte(0L, (byte)3);
            memOut.putByte(1L, (byte)3);
            memOut.putByte(2L, (byte)Family.objectToFamily(this).getID());
            memOut.putByte(3L, (byte)0);
            memOut.putByte(4L, (byte)this.lgArrLongs_);
            if (this.empty_) {
                memOut.setBits(5L, (byte)4);
            } else {
                memOut.clearBits(5L, (byte)4);
            }
            memOut.putShort(6L, this.seedHash_);
            memOut.putInt(8L, this.curCount_);
            memOut.putFloat(12L, 1.0f);
            memOut.putLong(16L, this.thetaLong_);
            if (this.curCount_ > 0) {
                memOut.putLongArray(24L, this.hashTable_, 0, 1 << this.lgArrLongs_);
            }
        }
        return byteArrOut;
    }

    @Override
    public void reset() {
        this.curCount_ = -1;
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = false;
        this.hashTable_ = null;
        if (this.mem_ != null) {
            Object memObj = this.mem_.array();
            long memAdd = this.mem_.getCumulativeOffset(0L);
            PreambleUtil.insertLgArrLongs(memObj, memAdd, this.lgArrLongs_);
            PreambleUtil.insertCurCount(memObj, memAdd, -1);
            PreambleUtil.insertThetaLong(memObj, memAdd, Long.MAX_VALUE);
            PreambleUtil.clearEmpty(memObj, memAdd);
        }
    }

    @Override
    public Family getFamily() {
        return Family.INTERSECTION;
    }

    private void performIntersect(Sketch sketchIn) {
        long hashIn;
        int i;
        long[] hashTable;
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int arrLongsIn = cacheIn.length;
        if (this.mem_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            this.mem_.getLongArray(24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            for (i = 0; i < arrLongsIn && (hashIn = cacheIn[i]) < this.thetaLong_; ++i) {
                int foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn);
                if (foundIdx == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        } else {
            for (i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.curCount_ = matchSetCount;
        this.lgArrLongs_ = IntersectionImpl.computeMinLgArrLongsFromCount(matchSetCount);
        if (this.mem_ != null) {
            Object memObj = this.mem_.array();
            long memAdd = this.mem_.getCumulativeOffset(0L);
            PreambleUtil.insertCurCount(memObj, memAdd, matchSetCount);
            PreambleUtil.insertLgArrLongs(memObj, memAdd, this.lgArrLongs_);
            this.mem_.clear(24L, 8 << this.lgArrLongs_);
        } else {
            Arrays.fill(this.hashTable_, 0, 1 << this.lgArrLongs_, 0L);
        }
        this.moveDataToTgt(matchSet, matchSetCount);
    }

    private void moveDataToTgt(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        if (this.mem_ != null) {
            Object memObj = this.mem_.array();
            long memAdd = this.mem_.getCumulativeOffset(0L);
            int preBytes = 24;
            int lgArrLongs = this.lgArrLongs_;
            long thetaLong = this.thetaLong_;
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(thetaLong, hashIn)) continue;
                HashOperations.fastHashInsertOnly(memObj, memAdd, lgArrLongs, hashIn, 24);
                ++tmpCnt;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
                HashOperations.hashInsertOnly(this.hashTable_, this.lgArrLongs_, hashIn);
                ++tmpCnt;
            }
        }
        assert (tmpCnt == count) : "Intersection Count Check: got: " + tmpCnt + ", expected: " + count;
    }

    private static final int checkMaxLgArrLongs(Memory dstMem) {
        int preBytes = 24;
        long cap = dstMem.getCapacity();
        int maxLgArrLongs = Integer.numberOfTrailingZeros(Util.floorPowerOf2((int)(cap - 24L)) >>> 3);
        if (maxLgArrLongs < 5) {
            throw new SketchesArgumentException("dstMem not large enough for minimum sized hash table: " + cap);
        }
        return maxLgArrLongs;
    }
}

