/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.theta;

import java.util.Arrays;
import shade.com.yahoo.sketches.HashOperations;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.SketchesException;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.theta.CompactSketch;
import shade.com.yahoo.sketches.theta.HeapCompactOrderedSketch;

public class PairwiseSetOperations {
    public static CompactSketch intersect(CompactSketch skA, CompactSketch skB) {
        if (skA == null && skB == null) {
            return null;
        }
        if (skA == null) {
            return new HeapCompactOrderedSketch(new long[0], true, skB.getSeedHash(), 0, skB.getThetaLong());
        }
        if (skB == null) {
            return new HeapCompactOrderedSketch(new long[0], true, skA.getSeedHash(), 0, skA.getThetaLong());
        }
        short seedHash = Util.checkSeedHashes(skA.getSeedHash(), skB.getSeedHash());
        if (!skB.isOrdered()) {
            throw new SketchesArgumentException("skB must be ordered!");
        }
        if (!skA.isOrdered()) {
            throw new SketchesArgumentException("skA must be ordered!");
        }
        boolean emptyA = skA.isEmpty();
        boolean emptyB = skB.isEmpty();
        boolean emptyRule = emptyA || emptyB;
        long thetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        if (emptyRule) {
            return new HeapCompactOrderedSketch(new long[0], emptyRule, seedHash, 0, thetaLong);
        }
        long[] cacheA = skA.isDirect() ? skA.getCache() : (long[])skA.getCache().clone();
        long[] cacheB = skB.isDirect() ? skB.getCache() : (long[])skB.getCache().clone();
        int aLen = cacheA.length;
        int bLen = cacheB.length;
        long[] outCache = new long[Math.min(aLen, bLen)];
        int indexA = 0;
        int indexB = 0;
        int outCount = 0;
        while (indexA < aLen && indexB < bLen) {
            long hashA = cacheA[indexA];
            long hashB = cacheB[indexB];
            if (hashA >= thetaLong || hashB >= thetaLong) break;
            if (hashA == hashB) {
                outCache[outCount++] = hashA;
                ++indexA;
                ++indexB;
                continue;
            }
            if (hashA < hashB) {
                ++indexA;
                continue;
            }
            ++indexB;
        }
        return new HeapCompactOrderedSketch(Arrays.copyOf(outCache, outCount), emptyRule, seedHash, outCount, thetaLong);
    }

    public static CompactSketch aNotB(CompactSketch skA, CompactSketch skB) {
        long[] cacheA;
        if (skA == null && skB == null) {
            return null;
        }
        if (skA == null) {
            if (!skB.isOrdered()) {
                throw new SketchesException("skB must be ordered!");
            }
            return new HeapCompactOrderedSketch(new long[0], true, skB.getSeedHash(), 0, skB.getThetaLong());
        }
        if (skB == null) {
            if (!skA.isOrdered()) {
                throw new SketchesException("skA must be ordered!");
            }
            return skA;
        }
        short seedHash = Util.checkSeedHashes(skA.getSeedHash(), skB.getSeedHash());
        if (!skB.isOrdered()) {
            throw new SketchesArgumentException("skB must be ordered!");
        }
        if (!skA.isOrdered()) {
            throw new SketchesArgumentException("skA must be ordered!");
        }
        boolean emptyA = skA.isEmpty();
        boolean emptyB = skB.isEmpty();
        boolean bothEmpty = emptyA && emptyB;
        long thetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        boolean emptyRule = emptyA;
        if (emptyA || bothEmpty) {
            return new HeapCompactOrderedSketch(new long[0], emptyRule, seedHash, 0, thetaLong);
        }
        long[] lArray = cacheA = skA.isDirect() ? skA.getCache() : (long[])skA.getCache().clone();
        if (emptyB) {
            int curCount = HashOperations.count(cacheA, thetaLong);
            long[] cache = CompactSketch.compactCache(cacheA, curCount, thetaLong, true);
            return new HeapCompactOrderedSketch(cache, emptyRule, seedHash, curCount, thetaLong);
        }
        long[] cacheB = skB.isDirect() ? skB.getCache() : (long[])skB.getCache().clone();
        int aLen = cacheA.length;
        int bLen = cacheB.length;
        long[] outCache = new long[aLen];
        int indexA = 0;
        int indexB = 0;
        int indexOut = 0;
        long hashA = cacheA[indexA];
        long hashB = cacheB[indexB];
        while (indexA < aLen || indexB < bLen) {
            if (hashA == hashB) {
                if (hashA >= thetaLong) break;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
                continue;
            }
            if (hashA < hashB) {
                if (hashA >= thetaLong) break;
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                continue;
            }
            if (hashB >= thetaLong) break;
            hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
        }
        int outLen = indexOut;
        return new HeapCompactOrderedSketch(Arrays.copyOf(outCache, outLen), emptyA, seedHash, outLen, thetaLong);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB) {
        return PairwiseSetOperations.union(skA, skB, 4096);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB, int k) {
        long hashB;
        boolean bothEmptyRule;
        if (skA == null && skB == null) {
            return null;
        }
        if (skA == null) {
            if (!skB.isOrdered()) {
                throw new SketchesException("skB must be ordered!");
            }
            if (skB.getRetainedEntries(true) > k) {
                long[] cacheB = skB.isDirect() ? skB.getCache() : (long[])skB.getCache().clone();
                long thetaLong = cacheB[k];
                long[] arrB = Arrays.copyOf(cacheB, k);
                return new HeapCompactOrderedSketch(arrB, skB.isEmpty(), skB.getSeedHash(), k, thetaLong);
            }
            return skB;
        }
        if (skB == null) {
            if (!skA.isOrdered()) {
                throw new SketchesException("skA must be ordered!");
            }
            if (skA.getRetainedEntries(true) > k) {
                long[] cacheA = skA.isDirect() ? skA.getCache() : (long[])skA.getCache().clone();
                long thetaLong = cacheA[k];
                long[] arrA = Arrays.copyOf(cacheA, k);
                return new HeapCompactOrderedSketch(arrA, skA.isEmpty(), skA.getSeedHash(), k, thetaLong);
            }
            return skA;
        }
        short seedHash = Util.checkSeedHashes(skA.getSeedHash(), skB.getSeedHash());
        if (!skB.isOrdered()) {
            throw new SketchesArgumentException("skB must be ordered!");
        }
        if (!skA.isOrdered()) {
            throw new SketchesArgumentException("skA must be ordered!");
        }
        boolean emptyA = skA.isEmpty();
        boolean emptyB = skB.isEmpty();
        boolean bl = bothEmptyRule = emptyA && emptyB;
        if (bothEmptyRule) {
            return skA.getThetaLong() < skB.getThetaLong() ? skA : skB;
        }
        long thetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        long[] cacheA = skA.isDirect() ? skA.getCache() : (long[])skA.getCache().clone();
        long[] cacheB = skB.isDirect() ? skB.getCache() : (long[])skB.getCache().clone();
        int aLen = cacheA.length;
        int bLen = cacheB.length;
        long[] outCache = new long[aLen + bLen];
        int indexA = 0;
        int indexB = 0;
        int indexOut = 0;
        long hashA = aLen == 0 ? thetaLong : cacheA[indexA];
        long l = hashB = bLen == 0 ? thetaLong : cacheB[indexB];
        while (indexA < aLen || indexB < bLen) {
            if (hashA == hashB) {
                if (hashA >= thetaLong) break;
                if (indexOut >= k) {
                    thetaLong = hashA;
                    break;
                }
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
                continue;
            }
            if (hashA < hashB) {
                if (hashA >= thetaLong) break;
                if (indexOut >= k) {
                    thetaLong = hashA;
                    break;
                }
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                continue;
            }
            if (hashB >= thetaLong) break;
            if (indexOut >= k) {
                thetaLong = hashB;
                break;
            }
            outCache[indexOut++] = hashB;
            hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
        }
        int outLen = indexOut;
        return new HeapCompactOrderedSketch(Arrays.copyOf(outCache, outLen), bothEmptyRule, seedHash, outLen, thetaLong);
    }
}

