/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.theta;

import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.theta.IntersectionImpl;
import shade.com.yahoo.sketches.theta.SetOperationBuilder;
import shade.com.yahoo.sketches.theta.UnionImpl;

public abstract class SetOperation {
    static final int CONST_PREAMBLE_LONGS = 3;

    SetOperation() {
    }

    public static final SetOperationBuilder builder() {
        return new SetOperationBuilder();
    }

    public static SetOperation heapify(Memory srcMem) {
        return SetOperation.heapify(srcMem, 9001L);
    }

    public static SetOperation heapify(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case UNION: {
                return UnionImpl.heapifyInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImpl.heapifyInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot heapify family: " + family.toString());
    }

    public static SetOperation wrap(Memory srcMem) {
        return SetOperation.wrap(srcMem, 9001L);
    }

    public static SetOperation wrap(Memory srcMem, long seed) {
        byte famID = srcMem.getByte(2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return UnionImpl.wrapInstance(srcMem, seed);
            }
            case INTERSECTION: {
                return IntersectionImpl.wrapInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("SetOperation cannot wrap family: " + family.toString());
    }

    public static int getMaxUnionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.UNION.getMaxPreLongs() << 3);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        int bytes = (nomEnt << 4) + (Family.INTERSECTION.getMaxPreLongs() << 3);
        return bytes;
    }

    public abstract Family getFamily();

    static short computeSeedHash(long seed) {
        return Util.computeSeedHash(seed);
    }

    static final int computeMinLgArrLongsFromCount(int count) {
        int upperCount = (int)Math.ceil((double)count / 0.9375);
        int arrLongs = Math.max(Util.ceilingPowerOf2(upperCount), 32);
        int newLgArrLongs = Integer.numberOfTrailingZeros(arrLongs);
        return newLgArrLongs;
    }

    static boolean isValidSetOpID(int id) {
        Family family = Family.idToFamily(id);
        boolean ret = family == Family.UNION || family == Family.INTERSECTION || family == Family.A_NOT_B;
        return ret;
    }
}

