/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.theta;

import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.sketches.BinomialBoundsN;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.HashOperations;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.theta.CompactSketch;
import shade.com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import shade.com.yahoo.sketches.theta.DirectCompactSketch;
import shade.com.yahoo.sketches.theta.DirectQuickSelectSketch;
import shade.com.yahoo.sketches.theta.ForwardCompatibility;
import shade.com.yahoo.sketches.theta.HeapAlphaSketch;
import shade.com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import shade.com.yahoo.sketches.theta.HeapCompactSketch;
import shade.com.yahoo.sketches.theta.HeapQuickSelectSketch;
import shade.com.yahoo.sketches.theta.PreambleUtil;
import shade.com.yahoo.sketches.theta.UpdateSketch;

public abstract class Sketch {
    static final int DEFAULT_LG_RESIZE_FACTOR = 3;

    Sketch() {
    }

    public double getEstimate() {
        return Sketch.estimate(this.getThetaLong(), this.getRetainedEntries(true), this.isEmpty());
    }

    public double getLowerBound(int numStdDev) {
        return this.isEstimationMode() ? Sketch.lowerBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public int getRetainedEntries() {
        return this.getRetainedEntries(true);
    }

    public abstract int getRetainedEntries(boolean var1);

    public double getTheta() {
        return (double)this.getThetaLong() / 9.223372036854776E18;
    }

    public int getCountLessThanTheta(double theta) {
        long thetaLong = (long)(9.223372036854776E18 * theta);
        return HashOperations.count(this.getCache(), thetaLong);
    }

    public double getUpperBound(int numStdDev) {
        return this.isEstimationMode() ? Sketch.upperBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public abstract boolean isEmpty();

    public boolean isEstimationMode() {
        return Sketch.estMode(this.getThetaLong(), this.isEmpty());
    }

    public abstract byte[] toByteArray();

    public abstract Family getFamily();

    public String toString() {
        return this.toString(true, false, 8, true);
    }

    public String toString(boolean sketchSummary, boolean dataDetail, int width, boolean hexMode) {
        StringBuilder sb = new StringBuilder();
        long[] cache = this.getCache();
        int nomLongs = 0;
        int arrLongs = cache.length;
        long seed = 0L;
        float p = 0.0f;
        int rf = 0;
        boolean updateSketch = this instanceof UpdateSketch;
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        if (updateSketch) {
            UpdateSketch uis = (UpdateSketch)this;
            nomLongs = 1 << uis.getLgNomLongs();
            seed = uis.getSeed();
            arrLongs = 1 << uis.getLgArrLongs();
            p = uis.getP();
            rf = uis.getResizeFactor().getValue();
        }
        if (dataDetail) {
            int w;
            int n = w = width > 0 ? width : 8;
            if (curCount > 0) {
                sb.append("### SKETCH DATA DETAIL");
                int j = 0;
                for (int i = 0; i < arrLongs; ++i) {
                    long h = cache[i];
                    if (h <= 0L || h >= thetaLong) continue;
                    if (j % w == 0) {
                        sb.append(Util.LS).append(String.format("   %6d", j + 1));
                    }
                    if (hexMode) {
                        sb.append(" " + Util.zeroPad(Long.toHexString(h), 16) + ",");
                    } else {
                        sb.append(String.format(" %20d,", h));
                    }
                    ++j;
                }
                sb.append(Util.LS).append("### END DATA DETAIL").append(Util.LS + Util.LS);
            }
        }
        if (sketchSummary) {
            double thetaDbl = (double)thetaLong / 9.223372036854776E18;
            String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
            String thisSimpleName = this.getClass().getSimpleName();
            short seedHash = this.getSeedHash();
            sb.append(Util.LS);
            sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            if (updateSketch) {
                sb.append("   Nominal Entries (k)     : ").append(nomLongs).append(Util.LS);
            }
            sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
            sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
            sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
            if (updateSketch) {
                sb.append("   p                       : ").append(p).append(Util.LS);
            }
            sb.append("   Theta (double)          : ").append(thetaDbl).append(Util.LS);
            sb.append("   Theta (long)            : ").append(thetaLong).append(Util.LS);
            sb.append("   Theta (long) hex        : ").append(thetaHex).append(Util.LS);
            sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
            sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
            if (updateSketch) {
                sb.append("   Resize Factor           : ").append(rf).append(Util.LS);
            }
            sb.append("   Array Size Entries      : ").append(arrLongs).append(Util.LS);
            sb.append("   Retained Entries        : ").append(curCount).append(Util.LS);
            if (updateSketch) {
                sb.append("   Update Seed             : ").append(Long.toHexString(seed)).append(" | ").append(Long.toString(seed)).append(Util.LS);
            }
            sb.append("   Seed Hash               : ").append(seedHash).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }

    public static Sketch heapify(Memory srcMem) {
        return Sketch.heapify(srcMem, 9001L);
    }

    public static Sketch heapify(Memory srcMem, long seed) {
        byte serVer = srcMem.getByte(1L);
        if (serVer == 3) {
            byte famID = srcMem.getByte(2L);
            boolean ordered = srcMem.isAnyBitsSet(5L, (byte)16);
            return Sketch.constructHeapSketch(famID, ordered, srcMem, seed);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seed);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, seed);
        }
        throw new SketchesArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static Sketch wrap(Memory srcMem) {
        return Sketch.wrap(srcMem, 9001L);
    }

    public static Sketch wrap(Memory srcMem, long seed) {
        int familyID;
        int serVer;
        int preLongs;
        boolean readOnly = srcMem.isReadOnly();
        boolean direct = srcMem.isDirect();
        long pre0 = srcMem.getLong(0L);
        if (readOnly && !direct) {
            preLongs = srcMem.getByte(0L) & 0x3F;
            serVer = srcMem.getByte(1L) & 0xFF;
            familyID = srcMem.getByte(2L) & 0xFF;
        } else {
            Object memObj = srcMem.array();
            long memAdd = srcMem.getCumulativeOffset(0L);
            preLongs = PreambleUtil.extractPreLongs(memObj, memAdd);
            serVer = PreambleUtil.extractSerVer(memObj, memAdd);
            familyID = PreambleUtil.extractFamilyID(memObj, memAdd);
        }
        Family family = Family.idToFamily(familyID);
        switch (family) {
            case QUICKSELECT: {
                if (serVer == 3 && preLongs == 3) {
                    return DirectQuickSelectSketch.wrapInstance(srcMem, seed);
                }
                throw new SketchesArgumentException("Corrupted: " + (Object)((Object)family) + " family image: must have SerVer = 3 and preLongs = 3");
            }
            case COMPACT: {
                boolean ordered;
                if (serVer == 1) {
                    return ForwardCompatibility.heapify1to3(srcMem, seed);
                }
                if (serVer == 2) {
                    return ForwardCompatibility.heapify2to3(srcMem, seed);
                }
                byte flags = srcMem.getByte(5L);
                boolean compact = (flags & 8) > 0;
                boolean bl = ordered = (flags & 0x10) > 0;
                if (compact) {
                    return ordered ? DirectCompactOrderedSketch.wrapInstance(srcMem, pre0, seed) : DirectCompactSketch.wrapInstance(srcMem, pre0, seed);
                }
                throw new SketchesArgumentException("Corrupted: " + (Object)((Object)family) + " family image must have compact flag set");
            }
        }
        throw new SketchesArgumentException("Sketch cannot wrap family: " + (Object)((Object)family) + " as a Sketch");
    }

    public int getCurrentBytes(boolean compact) {
        int preBytes = this.getCurrentPreambleLongs(compact) << 3;
        int dataBytes = this.getCurrentDataLongs(compact) << 3;
        return preBytes + dataBytes;
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        return (numberOfEntries << 3) + (Family.COMPACT.getMaxPreLongs() << 3);
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.QUICKSELECT.getMaxPreLongs() << 3);
    }

    public static int getSerializationVersion(Memory mem) {
        return mem.getByte(1L);
    }

    public abstract boolean isCompact();

    public abstract boolean isOrdered();

    public abstract boolean isDirect();

    final int getCurrentDataLongs(boolean compact) {
        int longs = this instanceof CompactSketch || compact ? this.getRetainedEntries(true) : 1 << ((UpdateSketch)this).getLgArrLongs();
        return longs;
    }

    final int getCurrentPreambleLongs(boolean compact) {
        return compact ? Sketch.compactPreambleLongs(this.getThetaLong(), this.isEmpty()) : this.getPreambleLongs();
    }

    static final int compactPreambleLongs(long thetaLong, boolean empty) {
        return thetaLong < Long.MAX_VALUE ? 3 : (empty ? 1 : 2);
    }

    abstract int getPreambleLongs();

    abstract short getSeedHash();

    abstract long getThetaLong();

    abstract long[] getCache();

    abstract Memory getMemory();

    static boolean isValidSketchID(int id) {
        return id == Family.ALPHA.getID() || id == Family.QUICKSELECT.getID() || id == Family.COMPACT.getID();
    }

    static final double estimate(long thetaLong, int curCount, boolean empty) {
        if (Sketch.estMode(thetaLong, empty)) {
            double theta = (double)thetaLong / 9.223372036854776E18;
            return (double)curCount / theta;
        }
        return curCount;
    }

    static final double lowerBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getLowerBound(curCount, theta, numStdDev, empty);
    }

    static final double upperBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getUpperBound(curCount, theta, numStdDev, empty);
    }

    private static final boolean estMode(long thetaLong, boolean empty) {
        return thetaLong < Long.MAX_VALUE && !empty;
    }

    private static final Sketch constructHeapSketch(byte famID, boolean ordered, Memory srcMem, long seed) {
        boolean compact = srcMem.isAnyBitsSet(5L, (byte)8);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case ALPHA: {
                if (compact) {
                    throw new SketchesArgumentException("Possibly Corrupted " + (Object)((Object)family) + " image: cannot be compact");
                }
                return HeapAlphaSketch.heapifyInstance(srcMem, seed);
            }
            case QUICKSELECT: {
                return HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
            }
            case COMPACT: {
                if (!compact) {
                    throw new SketchesArgumentException("Possibly Corrupted " + (Object)((Object)family) + " image: must be compact");
                }
                return ordered ? HeapCompactOrderedSketch.heapifyInstance(srcMem, seed) : HeapCompactSketch.heapifyInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("Sketch cannot heapify family: " + (Object)((Object)family) + " as a Sketch");
    }
}

