/*
 * Decompiled with CFR 0.152.
 */
package shade.com.yahoo.sketches.theta;

import shade.com.yahoo.memory.Memory;
import shade.com.yahoo.memory.NativeMemory;
import shade.com.yahoo.sketches.Family;
import shade.com.yahoo.sketches.HashOperations;
import shade.com.yahoo.sketches.QuickSelect;
import shade.com.yahoo.sketches.ResizeFactor;
import shade.com.yahoo.sketches.SketchesArgumentException;
import shade.com.yahoo.sketches.Util;
import shade.com.yahoo.sketches.theta.CompactSketch;
import shade.com.yahoo.sketches.theta.DirectQuickSelectSketch;
import shade.com.yahoo.sketches.theta.HeapQuickSelectSketch;
import shade.com.yahoo.sketches.theta.SetOperation;
import shade.com.yahoo.sketches.theta.Sketch;
import shade.com.yahoo.sketches.theta.Union;
import shade.com.yahoo.sketches.theta.UpdateSketch;

final class UnionImpl
extends SetOperation
implements Union {
    private final UpdateSketch gadget_;
    private final short seedHash_;
    private long unionThetaLong_;

    private UnionImpl(UpdateSketch gadget, long seed) {
        this.gadget_ = gadget;
        this.seedHash_ = UnionImpl.computeSeedHash(seed);
    }

    static UnionImpl initNewHeapInstance(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        HeapQuickSelectSketch gadget = HeapQuickSelectSketch.initNewHeapInstance(lgNomLongs, seed, p, rf, true);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((Sketch)gadget).getThetaLong();
        return unionImpl;
    }

    static UnionImpl initNewDirectInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, Memory dstMem) {
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.initNewDirectInstance(lgNomLongs, seed, p, rf, dstMem, true);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((Sketch)gadget).getThetaLong();
        dstMem.putLong(24L, ((Sketch)gadget).getThetaLong());
        return unionImpl;
    }

    static UnionImpl heapifyInstance(Memory srcMem, long seed) {
        Family.UNION.checkFamilyID(srcMem.getByte(2L));
        HeapQuickSelectSketch gadget = HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = srcMem.getLong(24L);
        return unionImpl;
    }

    static UnionImpl fastWrap(Memory srcMem, long seed) {
        Family.UNION.checkFamilyID(srcMem.getByte(2L));
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.fastWrap(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = srcMem.getLong(24L);
        return unionImpl;
    }

    static UnionImpl wrapInstance(Memory srcMem, long seed) {
        Family.UNION.checkFamilyID(srcMem.getByte(2L));
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.wrapInstance(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = srcMem.getLong(24L);
        return unionImpl;
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        int gadgetCurCount = this.gadget_.getRetainedEntries(true);
        int k = 1 << this.gadget_.getLgNomLongs();
        long[] gadgetCacheCopy = this.gadget_.isDirect() ? this.gadget_.getCache() : (long[])this.gadget_.getCache().clone();
        long curGadgetThetaLong = this.gadget_.getThetaLong();
        long adjGadgetThetaLong = gadgetCurCount > k ? QuickSelect.selectExcludingZeros(gadgetCacheCopy, gadgetCurCount, k + 1) : curGadgetThetaLong;
        long unionThetaLong = this.gadget_.isDirect() ? this.gadget_.getMemory().getLong(24L) : this.unionThetaLong_;
        long minThetaLong = Math.min(Math.min(curGadgetThetaLong, adjGadgetThetaLong), unionThetaLong);
        int curCountOut = minThetaLong < curGadgetThetaLong ? HashOperations.count(gadgetCacheCopy, minThetaLong) : gadgetCurCount;
        long[] compactCacheOut = CompactSketch.compactCache(gadgetCacheCopy, curCountOut, minThetaLong, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheOut, this.gadget_.isEmpty(), this.seedHash_, curCountOut, minThetaLong, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public void reset() {
        this.gadget_.reset();
        this.unionThetaLong_ = this.gadget_.getThetaLong();
    }

    @Override
    public byte[] toByteArray() {
        byte[] gadgetByteArr = this.gadget_.toByteArray();
        NativeMemory mem = new NativeMemory(gadgetByteArr);
        mem.putLong(24L, this.unionThetaLong_);
        return gadgetByteArr;
    }

    @Override
    public Family getFamily() {
        return Family.UNION;
    }

    @Override
    public void update(Sketch sketchIn) {
        if (sketchIn == null) {
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        long thetaLongIn = sketchIn.getThetaLong();
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        int curCountIn = sketchIn.getRetainedEntries(true);
        if (sketchIn.isOrdered()) {
            if (sketchIn.isDirect()) {
                int offsetBytes;
                long hashIn;
                Memory skMem = sketchIn.getMemory();
                int preambleLongs = skMem.getByte(0L) & 0x3F;
                for (int i = 0; i < curCountIn && (hashIn = skMem.getLong(offsetBytes = preambleLongs + i << 3)) < this.unionThetaLong_; ++i) {
                    this.gadget_.hashUpdate(hashIn);
                }
            } else {
                long hashIn;
                long[] cacheIn = sketchIn.getCache();
                for (int i = 0; i < curCountIn && (hashIn = cacheIn[i]) < this.unionThetaLong_; ++i) {
                    this.gadget_.hashUpdate(hashIn);
                }
            }
        } else {
            long[] cacheIn = sketchIn.getCache();
            int arrLongs = cacheIn.length;
            int c = 0;
            for (int i = 0; i < arrLongs && c < curCountIn; ++i) {
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.unionThetaLong_) continue;
                this.gadget_.hashUpdate(hashIn);
                ++c;
            }
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.isDirect()) {
            this.gadget_.getMemory().putLong(24L, this.unionThetaLong_);
        }
    }

    @Override
    public void update(Memory skMem) {
        if (skMem == null) {
            return;
        }
        int cap = (int)skMem.getCapacity();
        byte fam = skMem.getByte(2L);
        byte serVer = skMem.getByte(1L);
        if (serVer == 1) {
            if (fam != 3) {
                throw new SketchesArgumentException("Family must be old SET_SKETCH: " + (Object)((Object)Family.idToFamily(fam)));
            }
            if (cap <= 24) {
                return;
            }
            this.processVer1(skMem);
        } else if (serVer == 2) {
            if (fam != 3) {
                throw new SketchesArgumentException("Family must be old SET_SKETCH: " + (Object)((Object)Family.idToFamily(fam)));
            }
            if (cap <= 8) {
                return;
            }
            this.processVer2(skMem);
        } else if (serVer == 3) {
            if (fam < 1 || fam > 3) {
                throw new SketchesArgumentException("Family must be Alpha, QuickSelect, or Compact: " + (Object)((Object)Family.idToFamily(fam)));
            }
            if (cap <= 8) {
                return;
            }
            this.processVer3(skMem);
        } else {
            throw new SketchesArgumentException("SerVer is unknown: " + serVer);
        }
    }

    @Override
    public void update(long datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(double datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(String datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(byte[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(char[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(int[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(long[] data) {
        this.gadget_.update(data);
    }

    private void processVer1(Memory skMem) {
        int offsetBytes;
        long hashIn;
        long thetaLongIn = skMem.getLong(16L);
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        int curCount = skMem.getInt(8L);
        int preLongs = 3;
        for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = 3 + i << 3)) < this.unionThetaLong_; ++i) {
            this.gadget_.hashUpdate(hashIn);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.isDirect()) {
            this.gadget_.getMemory().putLong(24L, this.unionThetaLong_);
        }
    }

    private void processVer2(Memory skMem) {
        int offsetBytes;
        long hashIn;
        long thetaLongIn;
        Util.checkSeedHashes(this.seedHash_, skMem.getShort(6L));
        int preLongs = skMem.getByte(0L) & 0x3F;
        int curCount = skMem.getInt(8L);
        if (preLongs == 1) {
            return;
        }
        if (preLongs == 2) {
            assert (curCount > 0);
            thetaLongIn = Long.MAX_VALUE;
        } else {
            thetaLongIn = skMem.getLong(16L);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
            this.gadget_.hashUpdate(hashIn);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.isDirect()) {
            this.gadget_.getMemory().putLong(24L, this.unionThetaLong_);
        }
    }

    private void processVer3(Memory skMem) {
        long thetaLongIn;
        Util.checkSeedHashes(this.seedHash_, skMem.getShort(6L));
        int preLongs = skMem.getByte(0L) & 0x3F;
        int curCount = skMem.getInt(8L);
        if (preLongs == 1) {
            return;
        }
        if (preLongs == 2) {
            assert (curCount > 0);
            thetaLongIn = Long.MAX_VALUE;
        } else {
            thetaLongIn = skMem.getLong(16L);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, thetaLongIn);
        boolean ordered = skMem.isAnyBitsSet(5L, (byte)16);
        if (ordered) {
            int offsetBytes;
            long hashIn;
            for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
                this.gadget_.hashUpdate(hashIn);
            }
        } else {
            boolean compact = skMem.isAnyBitsSet(5L, (byte)8);
            int size = compact ? curCount : 1 << skMem.getByte(4L);
            for (int i = 0; i < size; ++i) {
                int offsetBytes = preLongs + i << 3;
                long hashIn = skMem.getLong(offsetBytes);
                if (hashIn <= 0L || hashIn >= this.unionThetaLong_) continue;
                this.gadget_.hashUpdate(hashIn);
            }
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.isDirect()) {
            this.gadget_.getMemory().putLong(24L, this.unionThetaLong_);
        }
    }
}

