/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.network;

import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class NetworkUtils {
    public static String formatIpv4Addr(byte[] ip) {
        String ipStr = "";
        for (int i = 0; i < ip.length; ++i) {
            ipStr = ipStr + (ip[i] & 0xFF) + ".";
        }
        return ipStr.substring(0, ipStr.length() - 1);
    }

    public static String formatIpv6Addr(byte[] ip) {
        String ipStr = "";
        for (int i = 0; i < 16; i += 2) {
            ipStr = ipStr + UtilFunctions.convertFromIntToHexa(ip[i]) + UtilFunctions.convertFromIntToHexa(ip[i + 1]) + ":";
        }
        return ipStr.substring(0, ipStr.length() - 1);
    }

    public static String formatMacAddr(byte[] macAddr) {
        String macAddrStr = "";
        for (int i = 0; i < macAddr.length; ++i) {
            macAddrStr = macAddrStr + UtilFunctions.convertFromIntToHexa(macAddr[i]) + ":";
        }
        return macAddrStr.substring(0, macAddrStr.length() - 1);
    }

    public static String formatIpv6AddrWithPort(byte[] ip) {
        String ipStr = "";
        for (int i = 0; i < 16; i += 2) {
            ipStr = ipStr + UtilFunctions.convertFromIntToHexa(ip[i]) + UtilFunctions.convertFromIntToHexa(ip[i + 1]) + ":";
        }
        ipStr = ipStr.substring(0, ipStr.length() - 1) + "/" + (ip[16] & 0xFF);
        return ipStr;
    }
}

