/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure;

import shade.fr.bmartel.pcapdecoder.structure.BlockTypes;
import shade.fr.bmartel.pcapdecoder.structure.types.IPcapngType;
import shade.fr.bmartel.pcapdecoder.structure.types.impl.EnhancedPacketHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.impl.InterfaceDescriptionHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.impl.InterfaceStatisticsHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.impl.NameResolutionHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.impl.SectionHeader;

public class PcapNgStructureParser {
    private BlockTypes blockType = BlockTypes.UNKNOWN;
    private IPcapngType pcapStruct = null;
    private byte[] blockTotalLength = new byte[32];
    private byte[] blockData = new byte[0];
    private boolean isBigEndian = true;

    public PcapNgStructureParser(BlockTypes type, byte[] data, boolean isBigEndian) {
        this.blockType = type;
        this.blockData = data;
        this.isBigEndian = isBigEndian;
    }

    public void decode() {
        if (this.blockType == BlockTypes.SECTION_HEADER_BLOCK) {
            this.pcapStruct = new SectionHeader(this.blockData, this.isBigEndian, this.blockType);
        } else if (this.blockType == BlockTypes.INTERFACE_DESCRIPTION_BLOCK) {
            this.pcapStruct = new InterfaceDescriptionHeader(this.blockData, this.isBigEndian, this.blockType);
        } else if (this.blockType == BlockTypes.ENHANCES_PACKET_BLOCK) {
            this.pcapStruct = new EnhancedPacketHeader(this.blockData, this.isBigEndian, this.blockType);
        } else if (this.blockType != BlockTypes.SIMPLE_PACKET_BLOCK) {
            if (this.blockType == BlockTypes.NAME_RESOLUTION_BLOCK) {
                this.pcapStruct = new NameResolutionHeader(this.blockData, this.isBigEndian, this.blockType);
            } else if (this.blockType == BlockTypes.INTERFACE_STATISTICS_BLOCK) {
                this.pcapStruct = new InterfaceStatisticsHeader(this.blockData, this.isBigEndian, this.blockType);
            } else if (this.blockType == BlockTypes.PACKET_BLOCK) {
                // empty if block
            }
        }
    }

    public BlockTypes getBlockType() {
        return this.blockType;
    }

    public IPcapngType getPcapStruct() {
        return this.pcapStruct;
    }

    public byte[] getBlockTotalLength() {
        return this.blockTotalLength;
    }

    public byte[] getBlockData() {
        return this.blockData;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }
}

