/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.options;

import java.util.Arrays;
import shade.fr.bmartel.pcapdecoder.structure.BlockTypes;
import shade.fr.bmartel.pcapdecoder.structure.options.PcapOptions;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionEnhancedPacketHeaderObject;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionInterfaceDescriptionObject;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionInterfaceStatisticsObject;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionSectionHeaderObject;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionsNameResolutionObject;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionsRecordNameResolutionObject;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class OptionParser {
    private byte[] data = null;
    private BlockTypes type = null;
    private boolean isBigEndian = true;
    private IOptions option = null;
    private boolean isRecord = false;

    public OptionParser(byte[] data, boolean isBigEndian, BlockTypes type, boolean isRecord) {
        this.data = data;
        this.isBigEndian = isBigEndian;
        this.type = type;
        this.isRecord = isRecord;
    }

    public int decode() {
        int initIndex = 0;
        if (this.type == BlockTypes.SECTION_HEADER_BLOCK) {
            this.option = new OptionSectionHeaderObject();
        } else if (this.type == BlockTypes.INTERFACE_DESCRIPTION_BLOCK) {
            this.option = new OptionInterfaceDescriptionObject();
        } else if (this.type == BlockTypes.ENHANCES_PACKET_BLOCK) {
            this.option = new OptionEnhancedPacketHeaderObject();
        } else if (this.type == BlockTypes.INTERFACE_STATISTICS_BLOCK) {
            this.option = new OptionInterfaceStatisticsObject();
        } else if (this.type == BlockTypes.NAME_RESOLUTION_BLOCK) {
            this.option = this.isRecord ? new OptionsRecordNameResolutionObject() : new OptionsNameResolutionObject();
        }
        int optionLength = -1;
        while (optionLength != 0) {
            int endOfOption;
            int optionCode = 0;
            optionLength = 0;
            byte[] optionValue = null;
            if (this.isBigEndian) {
                optionCode = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(this.data, initIndex + 0, initIndex + 2));
                if (optionCode == 0) {
                    return initIndex += 2;
                }
                optionLength = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(this.data, initIndex + 2, initIndex + 4));
                if (optionLength > 0) {
                    optionValue = Arrays.copyOfRange(this.data, initIndex + 4, initIndex + 4 + optionLength);
                }
            } else {
                optionCode = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, initIndex + 0, initIndex + 2)));
                if (optionCode == 0) {
                    return initIndex += 2;
                }
                optionLength = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, initIndex + 2, initIndex + 4)));
                if (optionLength > 0) {
                    optionValue = UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, initIndex + 4, initIndex + 4 + optionLength));
                }
            }
            if (optionLength == 0) {
                initIndex += 2;
            } else {
                PcapOptions optionParser = new PcapOptions(optionCode, optionLength, optionValue, this.isBigEndian, this.type, this.option);
                optionParser.decode();
                initIndex += 4 + optionLength;
            }
            if ((endOfOption = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, (initIndex += optionLength % 2) + 0, initIndex + 2)))) != 0) continue;
            initIndex += 2;
        }
        return initIndex;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public BlockTypes getType() {
        return this.type;
    }

    public IOptions getOption() {
        return this.option;
    }
}

