/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.options.impl;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import shade.fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionInterfaceStatisticsObject;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class OptionsInterfaceStatisticsHeader
extends OptionsAbstr {
    private OptionInterfaceStatisticsObject commonObject = null;

    public OptionsInterfaceStatisticsHeader(int optionCode, byte[] data, boolean isBigEndian, IOptions currentOption) {
        super(optionCode, data, isBigEndian, currentOption);
        this.commonObject = (OptionInterfaceStatisticsObject)currentOption;
        this.decode();
    }

    public void decode() {
        try {
            switch (this.optionCode) {
                case 1: {
                    if (!this.isBigEndian) {
                        this.commonObject.setComment(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setComment(new String(this.data, "UTF-8"));
                    break;
                }
                case 2: {
                    if (!this.isBigEndian) {
                        this.commonObject.setCaptureStartTime(this.parseTimeStamp(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setCaptureStartTime(this.parseTimeStamp(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
                case 3: {
                    if (!this.isBigEndian) {
                        this.commonObject.setCaptureEndTime(this.parseTimeStamp(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setCaptureEndTime(this.parseTimeStamp(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
                case 4: {
                    this.commonObject.setPacketReceivedCount(UtilFunctions.convertByteArrayToLong(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
                case 5: {
                    if (!this.isBigEndian) {
                        this.commonObject.setPacketDropCount(UtilFunctions.convertByteArrayToLong(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setPacketDropCount(UtilFunctions.convertByteArrayToLong(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
                case 6: {
                    if (!this.isBigEndian) {
                        this.commonObject.setPacketAcceptedByFilterCount(UtilFunctions.convertByteArrayToLong(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setPacketAcceptedByFilterCount(UtilFunctions.convertByteArrayToLong(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
                case 7: {
                    if (!this.isBigEndian) {
                        this.commonObject.setPacketDroppedByOS(UtilFunctions.convertByteArrayToLong(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setPacketDroppedByOS(UtilFunctions.convertByteArrayToLong(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
                case 8: {
                    if (!this.isBigEndian) {
                        this.commonObject.setPacketDeliveredToUser(UtilFunctions.convertByteArrayToLong(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setPacketDeliveredToUser(UtilFunctions.convertByteArrayToLong(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private Long parseTimeStamp(byte[] data) {
        int i;
        byte[] high_timestamp = UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 0, 4));
        byte[] low_timestamp = UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 4, 8));
        byte[] finalTimestamp = new byte[8];
        for (i = 0; i < 4; ++i) {
            finalTimestamp[i] = high_timestamp[i];
        }
        for (i = 0; i < 4; ++i) {
            finalTimestamp[i + 4] = low_timestamp[i];
        }
        Long timestamp = (long)UtilFunctions.convertByteArrayToLong(finalTimestamp);
        return timestamp;
    }
}

