/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.options.impl;

import java.io.UnsupportedEncodingException;
import shade.fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionsNameResolutionObject;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class OptionsNameResolutionHeader
extends OptionsAbstr {
    private OptionsNameResolutionObject commonObject = null;

    public OptionsNameResolutionHeader(int optionCode, byte[] data, boolean isBigEndian, IOptions currentOption) {
        super(optionCode, data, isBigEndian, currentOption);
        this.commonObject = (OptionsNameResolutionObject)currentOption;
        this.decode();
    }

    public void decode() {
        try {
            switch (this.optionCode) {
                case 1: {
                    if (!this.isBigEndian) {
                        this.commonObject.setComment(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setComment(new String(this.data, "UTF-8"));
                    break;
                }
                case 2: {
                    if (!this.isBigEndian) {
                        this.commonObject.setDnsName(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setDnsName(new String(this.data, "UTF-8"));
                    break;
                }
                case 3: {
                    byte[] tempIpv4 = new byte[4];
                    tempIpv4 = !this.isBigEndian ? UtilFunctions.convertLeToBe(this.data) : this.data;
                    this.commonObject.setDnsIpv4Addr(this.formatIpv4Addr(tempIpv4));
                    break;
                }
                case 4: {
                    byte[] tempIpv6 = new byte[4];
                    tempIpv6 = !this.isBigEndian ? UtilFunctions.convertLeToBe(this.data) : this.data;
                    this.commonObject.setDnsIpv6Addr(this.formatIpv4Addr(tempIpv6));
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String formatIpv4Addr(byte[] ip) {
        String ipStr = "";
        for (int i = 0; i < ip.length; ++i) {
            ipStr = ipStr + ip[i] + ".";
        }
        return ipStr.substring(0, ipStr.length() - 1);
    }

    public String formatIpv6Addr(byte[] ip) {
        String ipStr = "";
        for (int i = 0; i < 16; i += 2) {
            ipStr = ipStr + UtilFunctions.convertFromIntToHexa(ip[i]) + UtilFunctions.convertFromIntToHexa(ip[i + 1]) + ":";
        }
        return ipStr.substring(0, ipStr.length() - 1);
    }
}

