/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.options.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import shade.fr.bmartel.pcapdecoder.network.DnsEntryObject;
import shade.fr.bmartel.pcapdecoder.network.NetworkUtils;
import shade.fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionsRecordNameResolutionObject;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class OptionsRecordNameResolutionHeader
extends OptionsAbstr {
    private OptionsRecordNameResolutionObject commonObject = null;

    public OptionsRecordNameResolutionHeader(int optionCode, byte[] data, boolean isBigEndian, IOptions currentOption) {
        super(optionCode, data, isBigEndian, currentOption);
        this.commonObject = (OptionsRecordNameResolutionObject)currentOption;
        this.decode();
    }

    public void decode() {
        try {
            switch (this.optionCode) {
                case 1: {
                    byte[] tempIpv4 = new byte[4];
                    tempIpv4 = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, this.data.length - 4, this.data.length)) : Arrays.copyOfRange(this.data, 0, 4);
                    String ipv4Addr = NetworkUtils.formatIpv4Addr(tempIpv4);
                    ArrayList<String> entries = new ArrayList<String>();
                    if (!this.isBigEndian) {
                        entries.add(new String(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 1, this.data.length - 4)), "UTF-8"));
                    } else {
                        entries.add(new String(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 4, this.data.length - 1)), "UTF-8"));
                    }
                    this.commonObject.addIpv4DnsEntry(new DnsEntryObject(entries, ipv4Addr));
                    break;
                }
                case 2: {
                    byte[] tempIpv6 = new byte[16];
                    tempIpv6 = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, this.data.length - 16, this.data.length)) : Arrays.copyOfRange(this.data, 0, 16);
                    String ipv6Addr = NetworkUtils.formatIpv6Addr(tempIpv6);
                    ArrayList<String> entriesIpv6 = new ArrayList<String>();
                    if (!this.isBigEndian) {
                        entriesIpv6.add(new String(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 1, this.data.length - 16)), "UTF-8"));
                    } else {
                        entriesIpv6.add(new String(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 16, this.data.length - 1)), "UTF-8"));
                    }
                    this.commonObject.addIpv6DnsEntry(new DnsEntryObject(entriesIpv6, ipv6Addr));
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

