/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.options.impl;

import java.io.UnsupportedEncodingException;
import shade.fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import shade.fr.bmartel.pcapdecoder.structure.options.object.OptionSectionHeaderObject;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class OptionsSectionHeader
extends OptionsAbstr {
    private OptionSectionHeaderObject commonObject = null;

    public OptionsSectionHeader(int optionCode, byte[] data, boolean isBigEndian, IOptions currentOption) {
        super(optionCode, data, isBigEndian, currentOption);
        this.commonObject = (OptionSectionHeaderObject)currentOption;
        this.decode();
    }

    public void decode() {
        try {
            switch (this.optionCode) {
                case 1: {
                    if (!this.isBigEndian) {
                        this.commonObject.setComment(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setComment(new String(this.data, "UTF-8"));
                    break;
                }
                case 2: {
                    if (!this.isBigEndian) {
                        this.commonObject.setHardware(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setHardware(new String(this.data, "UTF-8"));
                    break;
                }
                case 3: {
                    if (!this.isBigEndian) {
                        this.commonObject.setOs(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setOs(new String(this.data, "UTF-8"));
                    break;
                }
                case 4: {
                    if (!this.isBigEndian) {
                        this.commonObject.setUserAppl(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setUserAppl(new String(this.data, "UTF-8"));
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

