/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.types.impl;

import java.util.Arrays;
import shade.fr.bmartel.pcapdecoder.structure.BlockTypes;
import shade.fr.bmartel.pcapdecoder.structure.options.OptionParser;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptionsEnhancedPacketHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.IPcapngType;
import shade.fr.bmartel.pcapdecoder.structure.types.inter.IEnhancedPacketBLock;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class EnhancedPacketHeader
implements IEnhancedPacketBLock,
IPcapngType {
    private int interfaceId = -1;
    private int capturedLength = -1;
    private int packetLength = -1;
    private Long timestamp = -1L;
    private byte[] packetData = null;
    private IOptionsEnhancedPacketHeader options = null;

    public EnhancedPacketHeader(byte[] data, boolean isBigEndian, BlockTypes type) {
        byte[] high_timestamp;
        if (isBigEndian) {
            int i;
            this.interfaceId = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 0, 4));
            high_timestamp = Arrays.copyOfRange(data, 4, 8);
            byte[] low_timestamp = Arrays.copyOfRange(data, 8, 12);
            byte[] finalTimestamp = new byte[8];
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i] = high_timestamp[i];
            }
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i + 4] = low_timestamp[i];
            }
            this.timestamp = (long)UtilFunctions.convertByteArrayToLong(finalTimestamp);
            this.capturedLength = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 12, 16));
            this.packetLength = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 16, 20));
            this.packetData = this.capturedLength > 0 ? Arrays.copyOfRange(data, 20, 20 + this.capturedLength) : new byte[0];
        } else {
            int i;
            this.interfaceId = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 0, 4)));
            high_timestamp = UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 4, 8));
            byte[] low_timestamp = UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 8, 12));
            byte[] finalTimestamp = new byte[8];
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i] = high_timestamp[i];
            }
            for (i = 0; i < 4; ++i) {
                finalTimestamp[i + 4] = low_timestamp[i];
            }
            this.timestamp = (long)UtilFunctions.convertByteArrayToLong(finalTimestamp);
            this.capturedLength = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 12, 16)));
            this.packetLength = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 16, 20)));
            this.packetData = this.capturedLength > 0 ? Arrays.copyOfRange(data, 20, 20 + this.capturedLength) : new byte[0];
        }
        if (data.length > 20 + this.capturedLength) {
            OptionParser optionParser = new OptionParser(Arrays.copyOfRange(data, 20 + this.capturedLength + this.capturedLength % 2, data.length), isBigEndian, type, false);
            optionParser.decode();
            this.options = (IOptionsEnhancedPacketHeader)optionParser.getOption();
        }
    }

    @Override
    public int getInterfaceId() {
        return this.interfaceId;
    }

    @Override
    public Long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public int getCapturedLength() {
        return this.capturedLength;
    }

    @Override
    public int getPacketLength() {
        return this.packetLength;
    }

    @Override
    public byte[] getPacketData() {
        return this.packetData;
    }

    @Override
    public IOptionsEnhancedPacketHeader getOptions() {
        return this.options;
    }
}

