/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.types.impl;

import java.util.Arrays;
import shade.fr.bmartel.pcapdecoder.constant.LinkLayerConstants;
import shade.fr.bmartel.pcapdecoder.structure.BlockTypes;
import shade.fr.bmartel.pcapdecoder.structure.options.OptionParser;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptionsDescriptionHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.IPcapngType;
import shade.fr.bmartel.pcapdecoder.structure.types.inter.IDescriptionBlock;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class InterfaceDescriptionHeader
implements IDescriptionBlock,
IPcapngType {
    private int snapLen = -1;
    private String linkTypeStr = "";
    private int linkType = -1;
    private IOptionsDescriptionHeader options = null;

    public InterfaceDescriptionHeader(byte[] data, boolean isBigEndian, BlockTypes type) {
        int reserved = -1;
        if (isBigEndian) {
            this.linkType = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 0, 2));
            this.linkTypeStr = LinkLayerConstants.LINK_LAYER_LIST.get(this.linkType);
            reserved = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 2, 4));
            this.snapLen = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 4, 8));
        } else {
            this.linkType = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 0, 2)));
            this.linkTypeStr = LinkLayerConstants.LINK_LAYER_LIST.get(this.linkType);
            reserved = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 2, 4)));
            this.snapLen = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 4, 8)));
        }
        if (data.length > 8) {
            OptionParser optionParser = new OptionParser(Arrays.copyOfRange(data, 8, data.length), isBigEndian, type, false);
            optionParser.decode();
            this.options = (IOptionsDescriptionHeader)optionParser.getOption();
        }
    }

    @Override
    public int getSnapLen() {
        return this.snapLen;
    }

    @Override
    public String getLinkType() {
        return this.linkTypeStr;
    }

    @Override
    public IOptionsDescriptionHeader getOptions() {
        return this.options;
    }
}

