/*
 * Decompiled with CFR 0.152.
 */
package shade.fr.bmartel.pcapdecoder.structure.types.impl;

import java.util.Arrays;
import shade.fr.bmartel.pcapdecoder.structure.BlockTypes;
import shade.fr.bmartel.pcapdecoder.structure.options.OptionParser;
import shade.fr.bmartel.pcapdecoder.structure.options.inter.IOptionSectionHeader;
import shade.fr.bmartel.pcapdecoder.structure.types.IPcapngType;
import shade.fr.bmartel.pcapdecoder.structure.types.inter.ISectionHeaderBlock;
import shade.fr.bmartel.pcapdecoder.utils.UtilFunctions;

public class SectionHeader
implements ISectionHeaderBlock,
IPcapngType {
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int sectionLength = -1;
    private IOptionSectionHeader options = null;

    public SectionHeader(byte[] data, boolean isBigEndian, BlockTypes type) {
        if (isBigEndian) {
            this.minorVersion = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 0, 2));
            this.majorVersion = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 2, 4));
            this.sectionLength = UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(data, 4, 12));
        } else {
            this.minorVersion = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 0, 2)));
            this.majorVersion = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 2, 4)));
            this.sectionLength = UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(data, 4, 12)));
        }
        if (data.length > 11) {
            OptionParser optionParser = new OptionParser(Arrays.copyOfRange(data, 12, data.length), isBigEndian, type, false);
            optionParser.decode();
            this.options = (IOptionSectionHeader)optionParser.getOption();
        }
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getSectionLength() {
        return this.sectionLength;
    }

    @Override
    public IOptionSectionHeader getOptions() {
        return this.options;
    }
}

