/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.htrace;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import shade.org.apache.htrace.TimelineAnnotation;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonSerializer;
import shade.org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import shade.org.apache.htrace.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=SpanSerializer.class)
public interface Span {
    public static final long ROOT_SPAN_ID = 477902L;

    public void stop();

    public long getStartTimeMillis();

    public long getStopTimeMillis();

    public long getAccumulatedMillis();

    public boolean isRunning();

    public String getDescription();

    public long getSpanId();

    public long getTraceId();

    public Span child(String var1);

    public String toString();

    public long getParentId();

    public void addKVAnnotation(byte[] var1, byte[] var2);

    public void addTimelineAnnotation(String var1);

    public Map<byte[], byte[]> getKVAnnotations();

    public List<TimelineAnnotation> getTimelineAnnotations();

    public String getProcessId();

    public String toJson();

    public static class SpanSerializer
    extends JsonSerializer<Span> {
        @Override
        public void serialize(Span span, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            List<TimelineAnnotation> timelineAnnotations;
            jgen.writeStartObject();
            jgen.writeStringField("i", String.format("%016x", span.getTraceId()));
            jgen.writeStringField("s", String.format("%016x", span.getSpanId()));
            jgen.writeNumberField("b", span.getStartTimeMillis());
            jgen.writeNumberField("e", span.getStopTimeMillis());
            jgen.writeStringField("d", span.getDescription());
            jgen.writeStringField("r", span.getProcessId());
            jgen.writeArrayFieldStart("p");
            if (span.getParentId() != 477902L) {
                jgen.writeString(String.format("%016x", span.getParentId()));
            }
            jgen.writeEndArray();
            Map<byte[], byte[]> traceInfoMap = span.getKVAnnotations();
            if (!traceInfoMap.isEmpty()) {
                jgen.writeObjectFieldStart("n");
                for (Map.Entry<byte[], byte[]> e : traceInfoMap.entrySet()) {
                    jgen.writeStringField(new String(e.getKey(), "UTF-8"), new String(e.getValue(), "UTF-8"));
                }
                jgen.writeEndObject();
            }
            if (!(timelineAnnotations = span.getTimelineAnnotations()).isEmpty()) {
                jgen.writeArrayFieldStart("t");
                for (TimelineAnnotation tl : timelineAnnotations) {
                    jgen.writeStartObject();
                    jgen.writeNumberField("t", tl.getTime());
                    jgen.writeStringField("m", tl.getMessage());
                    jgen.writeEndObject();
                }
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
    }
}

