/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.htrace;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.Callable;
import shade.org.apache.htrace.NullScope;
import shade.org.apache.htrace.Sampler;
import shade.org.apache.htrace.Span;
import shade.org.apache.htrace.SpanReceiver;
import shade.org.apache.htrace.TraceInfo;
import shade.org.apache.htrace.TraceScope;
import shade.org.apache.htrace.Tracer;
import shade.org.apache.htrace.impl.MilliSpan;
import shade.org.apache.htrace.impl.TrueIfTracingSampler;
import shade.org.apache.htrace.wrappers.TraceCallable;
import shade.org.apache.htrace.wrappers.TraceRunnable;

public class Trace {
    private static final Random random = new SecureRandom();

    public static TraceScope startSpan(String description) {
        return Trace.startSpan(description, TrueIfTracingSampler.INSTANCE);
    }

    public static TraceScope startSpan(String description, Span parent) {
        if (parent == null) {
            return Trace.startSpan(description);
        }
        return Trace.continueSpan(parent.child(description));
    }

    public static TraceScope startSpan(String description, TraceInfo tinfo) {
        if (tinfo == null) {
            return Trace.continueSpan(null);
        }
        MilliSpan newSpan = new MilliSpan(description, tinfo.traceId, tinfo.spanId, random.nextLong(), Tracer.getProcessId());
        return Trace.continueSpan(newSpan);
    }

    public static <T> TraceScope startSpan(String description, Sampler<T> s) {
        return Trace.startSpan(description, s, null);
    }

    public static TraceScope startSpan(String description, Sampler<TraceInfo> s, TraceInfo tinfo) {
        MilliSpan span = null;
        if (Trace.isTracing() || s.next(tinfo)) {
            span = new MilliSpan(description, tinfo.traceId, tinfo.spanId, random.nextLong(), Tracer.getProcessId());
        }
        return Trace.continueSpan(span);
    }

    public static <T> TraceScope startSpan(String description, Sampler<T> s, T info) {
        Span span = null;
        if (Trace.isTracing() || s.next(info)) {
            span = Tracer.getInstance().createNew(description);
        }
        return Trace.continueSpan(span);
    }

    public static TraceScope continueSpan(Span s) {
        if (s == null) {
            return NullScope.INSTANCE;
        }
        return Tracer.getInstance().continueSpan(s);
    }

    public static void setProcessId(String processId) {
        Tracer.processId = processId;
    }

    public static void removeReceiver(SpanReceiver rcvr) {
        Tracer.getInstance().removeReceiver(rcvr);
    }

    public static void addReceiver(SpanReceiver rcvr) {
        Tracer.getInstance().addReceiver(rcvr);
    }

    public static void addKVAnnotation(byte[] key, byte[] value) {
        Span s = Trace.currentSpan();
        if (s != null) {
            s.addKVAnnotation(key, value);
        }
    }

    public static void addTimelineAnnotation(String msg) {
        Span s = Trace.currentSpan();
        if (s != null) {
            s.addTimelineAnnotation(msg);
        }
    }

    public static boolean isTracing() {
        return Tracer.getInstance().isTracing();
    }

    public static Span currentSpan() {
        return Tracer.getInstance().currentSpan();
    }

    public static <V> Callable<V> wrap(Callable<V> callable) {
        if (Trace.isTracing()) {
            return new TraceCallable<V>(Trace.currentSpan(), callable);
        }
        return callable;
    }

    public static Runnable wrap(Runnable runnable) {
        if (Trace.isTracing()) {
            return new TraceRunnable(Trace.currentSpan(), runnable);
        }
        return runnable;
    }

    public static Runnable wrap(String description, Runnable runnable) {
        if (Trace.isTracing()) {
            return new TraceRunnable(Trace.currentSpan(), runnable, description);
        }
        return runnable;
    }
}

