/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.htrace.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import shade.org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import shade.org.apache.htrace.fasterxml.jackson.databind.deser.SettableBeanProperty;
import shade.org.apache.htrace.fasterxml.jackson.databind.deser.ValueInstantiator;
import shade.org.apache.htrace.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import shade.org.apache.htrace.fasterxml.jackson.databind.deser.impl.PropertyValue;
import shade.org.apache.htrace.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import shade.org.apache.htrace.fasterxml.jackson.databind.util.ClassUtil;

public final class PropertyBasedCreator {
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _properties;
    protected final int _propertyCount;
    protected final Object[] _defaultValues;
    protected final SettableBeanProperty[] _propertiesWithInjectables;

    protected PropertyBasedCreator(ValueInstantiator valueInstantiator, SettableBeanProperty[] creatorProps, Object[] defaultValues) {
        int len;
        this._valueInstantiator = valueInstantiator;
        this._properties = new HashMap();
        SettableBeanProperty[] propertiesWithInjectables = null;
        this._propertyCount = len = creatorProps.length;
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = creatorProps[i];
            this._properties.put(prop.getName(), prop);
            Object injectableValueId = prop.getInjectableValueId();
            if (injectableValueId == null) continue;
            if (propertiesWithInjectables == null) {
                propertiesWithInjectables = new SettableBeanProperty[len];
            }
            propertiesWithInjectables[i] = prop;
        }
        this._defaultValues = defaultValues;
        this._propertiesWithInjectables = propertiesWithInjectables;
    }

    public static PropertyBasedCreator construct(DeserializationContext ctxt, ValueInstantiator valueInstantiator, SettableBeanProperty[] srcProps) throws JsonMappingException {
        int len = srcProps.length;
        SettableBeanProperty[] creatorProps = new SettableBeanProperty[len];
        Object[] defaultValues = null;
        for (int i = 0; i < len; ++i) {
            Object nullValue;
            SettableBeanProperty prop = srcProps[i];
            if (!prop.hasValueDeserializer()) {
                prop = prop.withValueDeserializer(ctxt.findContextualValueDeserializer(prop.getType(), prop));
            }
            creatorProps[i] = prop;
            JsonDeserializer<Object> deser = prop.getValueDeserializer();
            Object object = nullValue = deser == null ? null : deser.getNullValue();
            if (nullValue == null && prop.getType().isPrimitive()) {
                nullValue = ClassUtil.defaultValue(prop.getType().getRawClass());
            }
            if (nullValue == null) continue;
            if (defaultValues == null) {
                defaultValues = new Object[len];
            }
            defaultValues[i] = nullValue;
        }
        return new PropertyBasedCreator(valueInstantiator, creatorProps, defaultValues);
    }

    public void assignDeserializer(SettableBeanProperty prop, JsonDeserializer<Object> deser) {
        prop = prop.withValueDeserializer(deser);
        this._properties.put(prop.getName(), prop);
    }

    public Collection<SettableBeanProperty> properties() {
        return this._properties.values();
    }

    public SettableBeanProperty findCreatorProperty(String name) {
        return this._properties.get(name);
    }

    public SettableBeanProperty findCreatorProperty(int propertyIndex) {
        for (SettableBeanProperty prop : this._properties.values()) {
            if (prop.getPropertyIndex() != propertyIndex) continue;
            return prop;
        }
        return null;
    }

    public PropertyValueBuffer startBuilding(JsonParser jp, DeserializationContext ctxt, ObjectIdReader oir) {
        PropertyValueBuffer buffer = new PropertyValueBuffer(jp, ctxt, this._propertyCount, oir);
        if (this._propertiesWithInjectables != null) {
            buffer.inject(this._propertiesWithInjectables);
        }
        return buffer;
    }

    public Object build(DeserializationContext ctxt, PropertyValueBuffer buffer) throws IOException {
        Object bean = this._valueInstantiator.createFromObjectWith(ctxt, buffer.getParameters(this._defaultValues));
        bean = buffer.handleIdValue(ctxt, bean);
        PropertyValue pv = buffer.buffered();
        while (pv != null) {
            pv.assign(bean);
            pv = pv.next;
        }
        return bean;
    }
}

