/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.htrace.fasterxml.jackson.databind.ext;

import java.io.IOException;
import java.lang.reflect.Type;
import shade.javax.xml.datatype.Duration;
import shade.javax.xml.datatype.XMLGregorianCalendar;
import shade.javax.xml.namespace.QName;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonGenerationException;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import shade.org.apache.htrace.fasterxml.jackson.databind.BeanDescription;
import shade.org.apache.htrace.fasterxml.jackson.databind.JavaType;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonNode;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonSerializer;
import shade.org.apache.htrace.fasterxml.jackson.databind.SerializationConfig;
import shade.org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import shade.org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shade.org.apache.htrace.fasterxml.jackson.databind.ser.Serializers;
import shade.org.apache.htrace.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import shade.org.apache.htrace.fasterxml.jackson.databind.ser.std.StdSerializer;
import shade.org.apache.htrace.fasterxml.jackson.databind.ser.std.ToStringSerializer;

public class CoreXMLSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Duration.class.isAssignableFrom(raw) || QName.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(raw)) {
            return new XMLGregorianCalendarSerializer();
        }
        return null;
    }

    public static class XMLGregorianCalendarSerializer
    extends StdSerializer<XMLGregorianCalendar> {
        public XMLGregorianCalendarSerializer() {
            super(XMLGregorianCalendar.class);
        }

        @Override
        public void serialize(XMLGregorianCalendar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            CalendarSerializer.instance.serialize(value.toGregorianCalendar(), jgen, provider);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            return CalendarSerializer.instance.getSchema(provider, typeHint);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            CalendarSerializer.instance.acceptJsonFormatVisitor(visitor, null);
        }
    }
}

