/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonGenerationException;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import shade.org.apache.htrace.fasterxml.jackson.databind.JavaType;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonNode;
import shade.org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import shade.org.apache.htrace.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import shade.org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shade.org.apache.htrace.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;

@JacksonStdImpl
public final class BooleanSerializer
extends NonTypedScalarSerializerBase<Boolean> {
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(Boolean.class);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeBoolean(value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectBooleanFormat(typeHint);
        }
    }
}

