/*
 * Decompiled with CFR 0.152.
 */
package shade.org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import shade.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import shade.org.apache.htrace.fasterxml.jackson.databind.JavaType;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import shade.org.apache.htrace.fasterxml.jackson.databind.JsonNode;
import shade.org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import shade.org.apache.htrace.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import shade.org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shade.org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import shade.org.apache.htrace.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public final class NumberSerializer
extends StdScalarSerializer<Number> {
    public static final NumberSerializer instance = new NumberSerializer();

    public NumberSerializer() {
        super(Number.class);
    }

    @Override
    public void serialize(Number value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value instanceof BigDecimal) {
            jgen.writeNumber((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            jgen.writeNumber((BigInteger)value);
        } else if (value instanceof Integer) {
            jgen.writeNumber(value.intValue());
        } else if (value instanceof Long) {
            jgen.writeNumber(value.longValue());
        } else if (value instanceof Double) {
            jgen.writeNumber(value.doubleValue());
        } else if (value instanceof Float) {
            jgen.writeNumber(value.floatValue());
        } else if (value instanceof Byte || value instanceof Short) {
            jgen.writeNumber(value.intValue());
        } else {
            jgen.writeNumber(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonNumberFormatVisitor v2 = visitor.expectNumberFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.BIG_DECIMAL);
        }
    }
}

