package com.kingdee.ebservice.itrus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;


public class ItrusConfigUtils {

	private static boolean inited = false;
	private static ItrusConfigUtils configUtils;
	private static Properties props;
	private String itrusPath;
	
	private ItrusConfigUtils(String itrusPath){
		this.itrusPath = itrusPath;
	}
	
	public static ItrusConfigUtils getInstance(String itrusPath){
		if(!inited){
			init(itrusPath);
			configUtils = new ItrusConfigUtils(itrusPath);
			//ϳʼʶÿζ³ʼ
			//inited = true;
		}
		return configUtils;
	}

	private static void init(String itrusPath){
		props = new Properties();
		InputStream in = null;
		try {
			String fileName = ItrusConfigHelper.getInstance(itrusPath).getEBItrusConfigFilePath();
			in = new FileInputStream(new File(fileName));
			props.load(in);
		} catch (IOException e) {
		} catch (Exception e) {
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
				}
			}
		}
	}
	
	public void setInited(boolean inited) {
		ItrusConfigUtils.inited = inited;
	}
	
	public Map<String, String> getAllConfigs(){
		Iterator<Entry<Object, Object>> iter = props.entrySet().iterator();
		Map<String, String> configsMap = new HashMap<String, String>();
		while(iter.hasNext()){
			Entry<Object, Object> entry = (Entry<Object, Object>) iter.next();
			configsMap.put((String)entry.getKey(), (String)entry.getValue());
		}
		return configsMap;
	}
	
	public void saveAllConfigs(Map<String, String> configsMap) throws Exception{
		Iterator<Entry<String, String>> iterator = configsMap.entrySet().iterator();
		while(iterator.hasNext()){
			Entry<String, String> next = iterator.next();
			props.setProperty(next.getKey(), next.getValue());
		}
		writeProperties();
	}
	
	public boolean getValueAsBoolean(String key, boolean defaultValue){
		String retValue = getValue(key, null);
		if(retValue != null){
			return "true".equalsIgnoreCase(retValue)?true:false;
		} else {
			return defaultValue;
		}
	}
	
	public String getValue(String property, String defaultValue) {
		String value = getValue(property);
		return (null == value) ? defaultValue: value;
	}
	
	public String getValue(String property) {
		return props.getProperty(property);
	}
	
	private void writeProperties() throws Exception {
		OutputStream fos = null;
		try {
			String filePath = ItrusConfigHelper.getInstance(itrusPath).getEBItrusConfigFilePath();
			fos = new FileOutputStream(filePath);
			props.store(fos, "");
		} catch (IOException e) {
			throw new Exception("itrusʧ:" + e);
		} catch (Exception e) {
			throw new Exception("itrusʧ:" + e);
		} finally {
			if(fos != null){
				try {
					fos.close();
				} catch (IOException e) {
				}
			}
		}
	}
}
