package com.kingdee.ebservice.itrus;

import org.apache.log4j.Logger;

import com.itrus.obm.iTrusObm;
import com.itrus.pki.rsa.iTrusRSAAPI;

public class ItrusHelper {
	
	private iTrusObm itrus;
	
	private static Logger logger = Logger.getLogger(ItrusHelper.class);
	
	/**
	 * ǩܣȽܺǩ
	 * @throws BankServiceException 
	 */
	private ItrusHelper(String path) throws Exception{
		if(itrus == null){
			logger.info("Init CA config...");
			new iTrusRSAAPI(path);
			itrus = new iTrusObm();
		}
		logger.info("CA config has been Inited.");
	}
	
	public static ItrusHelper getInstance(String itrusPath) throws Exception{
		//modified by Jimmy 201621610:25:51 δȡCAļǷCAΪfalseʱʼCAģ
		ItrusConfigHelper helper = ItrusConfigHelper.getInstance(itrusPath);
		if(!helper.isUseItrus()) {
			return null;
		}
		String itrusRootPath = helper.getItrusConfigPath();
		return new ItrusHelper(itrusRootPath);
	}
	
	public String decode(String encryMessage) throws Exception{
		return itrus.decode(encryMessage);
	}
	public String encode(String oriMessage) throws Exception{
		return itrus.encode(oriMessage);
	}
	public String sign(String plaintext) throws Exception{
		return itrus.sign(plaintext);
	}
	
	public boolean verify(String plaintext, String signatureBase64) throws Exception{
		return itrus.verify(plaintext, signatureBase64);
	}


}
