package com.kingdee.ws.ca;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.apache.log4j.Logger;

import com.kingdee.bos.ebservice.BalanceRequestExt;
import com.kingdee.bos.ebservice.BalanceResponseExt;
import com.kingdee.bos.ebservice.DelAccountsRequestExt;
import com.kingdee.bos.ebservice.DelAccountsResponseExt;
import com.kingdee.bos.ebservice.DetailRequestExt;
import com.kingdee.bos.ebservice.DetailResponseExt;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.LinkPayRequestExt;
import com.kingdee.bos.ebservice.LinkPayResponseExt;
import com.kingdee.bos.ebservice.PayRequestExt;
import com.kingdee.bos.ebservice.PayResponseExt;
import com.kingdee.bos.ebservice.QueryLinkPayRequestExt;
import com.kingdee.bos.ebservice.QueryLinkPayResponseExt;
import com.kingdee.bos.ebservice.QueryPayRequestExt;
import com.kingdee.bos.ebservice.QueryPayResponseExt;
import com.kingdee.bos.ebservice.SyncAccountsRequestExt;
import com.kingdee.bos.ebservice.SyncAccountsResponseExt;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ebservice.itrus.ItrusHelper;
import com.kingdee.ws.ca.impl.EBSignProviderUtils;
import com.kingdee.ws.ca.impl.IEncryptDataProvider;
import com.kingdee.ws.ca.impl.ISignUnit;
import com.kingdee.ws.ca.impl.SignPlainTextUtils;
import com.kingdee.ws.ca.utils.StringUtils;

public class EBExtUtils {
	
	private static final Logger logger = Logger.getLogger(EBExtUtils.class);
	private static final String ENCRYPT_SPLIT = "#&";
	private static EBExtUtils extUtils = null;
	private static ItrusConfigHelper helper = null;
	private static ItrusHelper itrusHelper = null;
	
	public static EBExtUtils getInstance(String configPath) throws Exception {
		if(null == extUtils) {
			itrusHelper = ItrusHelper.getInstance(configPath);
			extUtils = new EBExtUtils();
		}
		helper = ItrusConfigHelper.getInstance(configPath);
		return extUtils;
	}
	
	public static ItrusConfigHelper getConfigHelper() {
		return helper;
	}
	
	/**
	 * ǷCA
	 * @return
	 * 2015-7-1 11:02:35
	 * rd_jinlin_xie
	 */
	public static boolean isUseItrus() {
		return helper.isUseItrus();
	}
	
	
	private EBExtUtils() {};
	
	 /**
     * ǩ
     * @param rsp
     * @throws Exception
     */
    public static void signRqst(EBRequest req) throws Exception{
		if (!helper.isUseItrus()) {
			return;
		}
		
		if(req instanceof PayRequestExt && helper.needPayRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof QueryPayRequestExt && helper.needQueryRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof BalanceRequestExt && helper.needQueryRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof DetailRequestExt && helper.needQueryRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof LinkPayRequestExt && helper.needPayRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof QueryLinkPayRequestExt && helper.needQueryRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof DelAccountsRequestExt && helper.needPayRequestSignAndVerify()) {
			sign4Req(req);
		}
		
		else if(req instanceof SyncAccountsRequestExt && helper.needQueryRequestSignAndVerify()) {
			sign4Req(req);
		}
	}
	
	
    /**
     * 
     * @param rsp
     * @throws Exception
     */
	public static void encryptRqst(EBRequest req) throws Exception{
		if (!helper.isUseItrus()) {
			return;
		}
		
		if(req instanceof PayRequestExt && helper.needPayRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof QueryPayRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof BalanceRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof DetailRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof LinkPayRequestExt && helper.needPayRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof QueryLinkPayRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof DelAccountsRequestExt && helper.needPayRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
		
		else if(req instanceof SyncAccountsRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			encrypt4Req(req);
		}
	}
    
    
	/**
	 * 
	 * @param rqst
	 */
    public static void decryptRqst(EBRequest req){
		if (!helper.isUseItrus()) {
			return;
		}
		
		if(req instanceof PayRequestExt && helper.needPayRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof QueryPayRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof BalanceRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof DetailRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof LinkPayRequestExt && helper.needPayRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof QueryLinkPayRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof DelAccountsRequestExt && helper.needPayRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
		
		else if(req instanceof SyncAccountsRequestExt && helper.needQueryRequestEncryptAndDecrypt()) {
			decrypt4Rqst(req);
		}
    }
    
    /**
     * ǩ
     * @param rqst
     * @return
     */
    public static boolean verifyRqst(EBRequest req){
		if (!helper.isUseItrus()) {
			return true;
		}
		
		if(req instanceof PayRequestExt && helper.needPayRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		else if(req instanceof QueryPayRequestExt && helper.needQueryRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		else if(req instanceof BalanceRequestExt && helper.needQueryRequestSignAndVerify()) {
			return verify4Rqst(req);
		}

		else if(req instanceof DetailRequestExt && helper.needQueryRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		else if(req instanceof LinkPayRequestExt && helper.needPayRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		else if(req instanceof QueryLinkPayRequestExt && helper.needQueryRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		else if(req instanceof DelAccountsRequestExt && helper.needPayRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		else if(req instanceof SyncAccountsRequestExt && helper.needQueryRequestSignAndVerify()) {
			return verify4Rqst(req);
		}
		
		return true;
    }
    
    /**
     * ǩͼ
     * @param rsp
     * @throws Exception
     */
    public static void signAndEncrypt(EBResponse rsp) throws Exception {
		signRsp(rsp);
		encryptRsp(rsp);
    }
    
    /**
     * ǩͼ
     * @param rsp
     * @throws Exception
     */
    public static void signAndEncrypt(EBRequest req) throws Exception {
		signRqst(req);
		encryptRqst(req);
    }
    
    /**
     * ֤ܺǩ
     * @param req
     * @return
     * @throws Exception
     * 2015-4-20 11:29:03
     * rd_jinlin_xie
     */
    public static boolean decryptAndVerify(EBRequest req) throws Exception {
    	decryptRqst(req);
    	return verifyRqst(req);
    }
    
    /**
     * ֤ܺǩ
     * @param rsp
     * @return
     * @throws Exception
     * 2015-4-20 11:29:35
     * rd_jinlin_xie
     */
    public static boolean decryptAndVerify(EBResponse rsp) throws Exception {
    	decryptRsp(rsp);
    	return verifyRsp(rsp);
    }
    
    /**
     * Ӧǩ
     * @param rsp
     * @throws Exception
     */
    public static void signRsp(EBResponse rsp) throws Exception{
		if (!helper.isUseItrus()) {
			return;
		}
		
		if(rsp instanceof PayResponseExt && helper.needPayResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof QueryPayResponseExt && helper.needQueryResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof BalanceResponseExt && helper.needQueryResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof DetailResponseExt && helper.needQueryResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof LinkPayResponseExt && helper.needPayResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof QueryLinkPayResponseExt  && helper.needQueryResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof DelAccountsResponseExt && helper.needPayResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
		
		else if(rsp instanceof SyncAccountsResponseExt && helper.needQueryResponseSignAndVerify()) {
			sign4Rsp(rsp);
		}
	}
    
    /**
     * Ӧ
     * @param rsp
     * @throws Exception
     */
	public static void encryptRsp(EBResponse rsp) throws Exception{
		if (!helper.isUseItrus()) {
			return;
		}
		
		if(rsp instanceof PayResponseExt && helper.needPayResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof QueryPayResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof BalanceResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof DetailResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof LinkPayResponseExt && helper.needPayResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof QueryLinkPayResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof DelAccountsResponseExt && helper.needPayResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
		
		else if(rsp instanceof SyncAccountsResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			encrypt4Rsp(rsp);
		}
	}
    
	
	/**
	 * Ӧ
	 * @param rqst
	 */
    public static void decryptRsp(EBResponse rsp){
		if (!helper.isUseItrus()) {
			return;
		}
		
		if(rsp instanceof PayResponseExt && helper.needPayResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof QueryPayResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof BalanceResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof DetailResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof LinkPayResponseExt && helper.needPayResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof QueryLinkPayResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof DelAccountsResponseExt && helper.needPayResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
		
		else if(rsp instanceof SyncAccountsResponseExt && helper.needQueryResponseEncryptAndDecrypt()) {
			decrypt4Resp(rsp);
		}
    }
    
    /**
     * Ӧǩ
     * @param rqst
     * @return
     */
    public static boolean verifyRsp(EBResponse rsp){
		if (!helper.isUseItrus()) {
			return true;
		}
		
		if(rsp instanceof PayResponseExt && helper.needPayResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof QueryPayResponseExt && helper.needQueryResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof BalanceResponseExt && helper.needQueryResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof DetailResponseExt && helper.needQueryResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof LinkPayResponseExt && helper.needPayResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof QueryLinkPayResponseExt && helper.needQueryResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof DelAccountsResponseExt && helper.needPayResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		else if(rsp instanceof SyncAccountsResponseExt && helper.needQueryResponseSignAndVerify()) {
			return verify4Resp(rsp);
		}
		
		return true;
    }
	
   
    
    
    private static void decrypt4Rqst(EBRequest rqst) {
		IEncryptDataProvider provider = EBSignProviderUtils.getEncryDataProvider(rqst);
		String[] payHeaderEncodeFields = provider.getHeaderEncodeFields();
		String[] payBodyEncodeFields = provider.getBodyEncodeFields();
		String[] payDetailEncodeFields = provider.getOtherEncodeFields();
		ISignUnit signUnit = EBSignProviderUtils.getSignUnit(rqst);
		String encryptedData = EBSignProviderUtils.getEncryptedData(rqst);
		String decryptedData = "";
		try {
			decryptedData = itrusHelper.decode(encryptedData);
		} catch (Exception e) {
			logger.error("ܳ" + e);
			return;
		}
		logger.debug("ܺϢ" + decryptedData);
		String[] decryptedDataArr = decryptedData.split(ENCRYPT_SPLIT, -1);
		/*if(decryptedDataArr.length < (payHeaderEncodeFields.length + payBodyEncodeFields.length)){
			logger.error("ҵϵͳδȫֶϢ");
			return;
		}*/
		int currentPropertyIndex = 0;
		if(null != signUnit.getHeader()) {
			for(String payHeaderEncodeField : payHeaderEncodeFields){
				restoreSensitiveInfo(signUnit.getHeader(), payHeaderEncodeField, decryptedDataArr[currentPropertyIndex++]);
			}
		}
		if(null != signUnit.getBody()) {
			for(String payBodyEncodeField : payBodyEncodeFields){
				restoreSensitiveInfo(signUnit.getBody(), payBodyEncodeField, decryptedDataArr[currentPropertyIndex++]);
			}
		}
		if(null != signUnit.getDetails()) {
			for(Object payDetail : signUnit.getDetails()){
				for(String payDetailEncodeField : payDetailEncodeFields){
					restoreSensitiveInfo(payDetail, payDetailEncodeField, decryptedDataArr[currentPropertyIndex++]);
				}
			}
		}
    }
    
    
    private static void decrypt4Resp(EBResponse resp) {
    	IEncryptDataProvider provider = EBSignProviderUtils.getEncryDataProvider(resp);
		String[] payHeaderEncodeFields = provider.getHeaderEncodeFields();
		String[] payBodyEncodeFields = provider.getBodyEncodeFields();
		String[] payDetailEncodeFields = provider.getOtherEncodeFields();
		ISignUnit signUnit = EBSignProviderUtils.getSignUnit(resp);
		String encryptedData = EBSignProviderUtils.getEncryptedData(resp);
		String decryptedData = "";
		try {
			decryptedData = itrusHelper.decode(encryptedData);
		} catch (Exception e) {
			logger.error("ܳ" + e);
			return;
		}
		logger.debug("ܺϢ" + decryptedData);
		String[] decryptedDataArr = decryptedData.split(ENCRYPT_SPLIT, -1);
		/*if(decryptedDataArr.length < (payHeaderEncodeFields.length + payBodyEncodeFields.length)){
			logger.error("ҵϵͳδȫֶϢ");
			return;
		}*/
		int currentPropertyIndex = 0;
		if(null != signUnit.getHeader()) {
			for(String payHeaderEncodeField : payHeaderEncodeFields){
				restoreSensitiveInfo(signUnit.getHeader(), payHeaderEncodeField, decryptedDataArr[currentPropertyIndex++]);
			}
		}
		if(null != signUnit.getBody()) {
			for(String payBodyEncodeField : payBodyEncodeFields){
				restoreSensitiveInfo(signUnit.getBody(), payBodyEncodeField, decryptedDataArr[currentPropertyIndex++]);
			}
		}
		if(null != signUnit.getDetails()) {
			for(Object payDetail : signUnit.getDetails()){
				for(String payDetailEncodeField : payDetailEncodeFields){
					restoreSensitiveInfo(payDetail, payDetailEncodeField, decryptedDataArr[currentPropertyIndex++]);
				}
			}
		}
    }
    

    
    private static boolean verifyRqst4Pay(EBRequest rqst){
    	boolean verifyFlag = true;
    	if(rqst instanceof PayRequestExt){
    		PayRequestExt payRqstExt = (PayRequestExt)rqst;
    		String signedData = payRqstExt.getEbExt().getSignedData();
    		String plainText = SignPlainTextUtils.getSignPlainText(rqst);
    		try {
    			verifyFlag = itrusHelper.verify(plainText, signedData);
    		} catch (Exception e) {
    			logger.error("ǩ쳣" + e);
    			verifyFlag = false;
    		}
    	}
		return verifyFlag;
    }
    
    private static boolean verify4Rqst(EBRequest rqst) {
    	boolean verifyFlag = true;
    	String signedData = EBSignProviderUtils.getSignData(rqst);
    	ISignUnit text = EBSignProviderUtils.getSignUnit(rqst);
    	
    	try {
			verifyFlag = itrusHelper.verify(text.getRequstMixSignPlainText().replace("null", ""), signedData);
		} catch (Exception e) {
			logger.error("ǩ쳣" + e);
			verifyFlag = false;
		}
    	
    	return verifyFlag;
    }
    
    private static boolean verify4Resp(EBResponse resp) {
    	boolean verifyFlag = true;
    	String signedData = EBSignProviderUtils.getSignData(resp);
    	ISignUnit text = EBSignProviderUtils.getSignUnit(resp);
    	
    	try {
			verifyFlag = itrusHelper.verify(text.getResponseMixSignPlainText().replace("null", ""), signedData);
		} catch (Exception e) {
			logger.error("ǩ쳣" + e);
			verifyFlag = false;
		}
    	
    	return verifyFlag;
    }
    
    
    private static boolean verifyRqst4Query(EBRequest rqst){
    	boolean verifyFlag = true;
    	
    	return verifyFlag;
    }
    
    private static void signRsp4Pay(EBResponse rsp) throws Exception{
    	String plainText = SignPlainTextUtils.getSignPlainText(rsp);
    	String signedData = "";
		try {
			signedData = itrusHelper.sign(plainText);
		} catch (Exception e) {
			logger.error("Ӧǩʧܣ" + e);
			throw new Exception("Ӧǩʧ");
		}
		if(rsp instanceof PayResponseExt){
			PayResponseExt payRsp = (PayResponseExt)rsp;
			payRsp.getEbExt().setSignedData(signedData);
		}
    }
    
    private static void sign4Rsp(EBResponse rsp) throws Exception {
    	ISignUnit signTextProvider = EBSignProviderUtils.getSignUnit(rsp);
    	String plainText = signTextProvider.getResponseMixSignPlainText();
    	String signedData = "";
		try {
			signedData = itrusHelper.sign(plainText.replace("null", ""));
		} catch (Exception e) {
			logger.error("Ӧǩʧܣ" + e);
			throw new Exception("Ӧǩʧ");
		}
		EBSignProviderUtils.setSignData(rsp,signedData);
    }
    
    private static void sign4Req(EBRequest req) throws Exception {
    	ISignUnit signTextProvider = EBSignProviderUtils.getSignUnit(req);
    	String plainText = signTextProvider.getRequstMixSignPlainText();
    	String signedData = "";
		try {
			signedData = itrusHelper.sign(plainText.replace("null", ""));
		} catch (Exception e) {
			logger.error("Ӧǩʧܣ" + e);
			throw new Exception("Ӧǩʧ");
		}
		EBSignProviderUtils.setSignData(req,signedData);
    }
    

	
	
	private static void encrypt4Rsp(EBResponse rsp) throws Exception {
		String encryptedData = "";
		IEncryptDataProvider provider = EBSignProviderUtils.getEncryDataProvider(rsp);
		String[] payHeaderEncodeFields = provider.getHeaderEncodeFields();
		String[] payBodyEncodeFields = provider.getBodyEncodeFields();
		String[] payDetailEncodeFields = provider.getOtherEncodeFields();
		ISignUnit signUnit = EBSignProviderUtils.getSignUnit(rsp);
		StringBuffer oriData = new StringBuffer();
		if(null != signUnit.getHeader()) {
			for(String payHeaderEncodeField : payHeaderEncodeFields){
				oriData.append(replaceSensitiveInfo(signUnit.getHeader(), payHeaderEncodeField) + ENCRYPT_SPLIT);
			}
		}
		if(null != signUnit.getBody()) {
			for(String payBodyEncodeField : payBodyEncodeFields){
				oriData.append(replaceSensitiveInfo(signUnit.getBody(), payBodyEncodeField) + ENCRYPT_SPLIT);
			}
		}
		if(null != signUnit.getDetails()) {
			for(Object payDetail : signUnit.getDetails()){
				for(String payDetailEncodeField : payDetailEncodeFields){
					oriData.append(replaceSensitiveInfo(payDetail, payDetailEncodeField) + ENCRYPT_SPLIT);
				}
			}
		}
		try {
			encryptedData = itrusHelper.encode(oriData.toString());
			EBSignProviderUtils.setEncryData(rsp, encryptedData);
		} catch (Exception e) {
			logger.error("Ӧݼʧܣ" + e);
			throw new Exception("Ӧݼʧ");
		}
	}
	
	private static void encrypt4Req(EBRequest req) throws Exception {
		String encryptedData = "";
		IEncryptDataProvider provider = EBSignProviderUtils.getEncryDataProvider(req);
		ISignUnit signUnit = EBSignProviderUtils.getSignUnit(req);
		String[] payHeaderEncodeFields = provider.getHeaderEncodeFields();
		String[] payBodyEncodeFields = provider.getBodyEncodeFields();
		String[] payDetailEncodeFields = provider.getOtherEncodeFields();
		StringBuffer oriData = new StringBuffer();
		if(null != signUnit.getHeader()) {
			for(String payHeaderEncodeField : payHeaderEncodeFields){
				oriData.append(replaceSensitiveInfo(signUnit.getHeader(), payHeaderEncodeField) + ENCRYPT_SPLIT);
			}
		}
		if(null != signUnit.getBody()) {
			for(String payBodyEncodeField : payBodyEncodeFields){
				oriData.append(replaceSensitiveInfo(signUnit.getBody(), payBodyEncodeField) + ENCRYPT_SPLIT);
			}
		}
		if(null != signUnit.getDetails()) {
			for(Object payDetail : signUnit.getDetails()){
				for(String payDetailEncodeField : payDetailEncodeFields){
					oriData.append(replaceSensitiveInfo(payDetail, payDetailEncodeField) + ENCRYPT_SPLIT);
				}
			}
		}
		try {
			encryptedData = itrusHelper.encode(oriData.toString());
			EBSignProviderUtils.setEncryData(req, encryptedData);
		} catch (Exception e) {
			logger.error("ݼʧܣ" + e);
			throw new Exception("ݼʧ");
		}
	}
	

	
	/**
	 * ԭֶεʵֵ
	 * @param obj 
	 * @param property 
	 * @param value ʵֵ
	 */
    private static void restoreSensitiveInfo(Object obj, String field, String value){
    	if(StringUtils.isEmpty(field)){
    		return;
    	}
    	Class<?> clazz = obj.getClass();
    	String setterName = buildSetMethod(field);
    	try {
			Method setter = clazz.getDeclaredMethod(setterName, String.class);
			setter.invoke(obj, value);
		} catch (SecurityException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + e);
		} catch (NoSuchMethodException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + e);
		} catch (IllegalArgumentException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + e);
		} catch (IllegalAccessException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + e);
		} catch (InvocationTargetException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + e);
		}
    }
	
    
    
    
    
    private static String replaceSensitiveInfo(Object obj, String property){
    	if(null == property || property.length() == 0){
    		return "";
    	}
    	   	
    	Class<?> clazz = obj.getClass();
    	String setterName = buildSetMethod(property);
    	String getterName = buildGetMethod(property);
    	try {
    		Method setter = clazz.getDeclaredMethod(setterName, String.class);
			Method getter = clazz.getDeclaredMethod(getterName);
			String oriMessage = (String)getter.invoke(obj);
			setter.invoke(obj, "******");
			return oriMessage;
		} catch (SecurityException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + getterName + "" + e);
		} catch (NoSuchMethodException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + getterName + "" + e);
		} catch (IllegalArgumentException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + getterName + "" + e);
		} catch (IllegalAccessException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + getterName + "" + e);
		} catch (InvocationTargetException e) {
			logger.error("" + clazz.getName() + "" + setterName + "" + getterName + "" + e);
		}
		return "";
    }
    
    
    private static String buildGetMethod(String property){
    	return "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
    }
    
    private static String buildSetMethod(String property){
    	return "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
    }
    
    /*private static String getContentFromReserved1(String reserved1, String property){
    	if(StringUtils.isEmpty(reserved1) || StringUtils.isEmpty(property)){
    		return "";
    	}
    	String[] extMsgArr = reserved1.split(PROPERTY_SPLIT);
    	for(String extMsg : extMsgArr){
    		if(extMsg.contains(property + ":")){
    			return extMsg.substring(extMsg.indexOf(property) + (property + ":").length());
    		}
    	}
    	return "";
    }
    
    private static StringBuffer addContent2Reserved1(StringBuffer reserved1, String key, String value){
    	if(reserved1.length() > 0){
    		reserved1.append(PROPERTY_SPLIT);
    	}
    	return reserved1.append(key + ":" + value);
    }*/
}
