/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;


import com.kingdee.bos.ebservice.Detail;
import com.kingdee.bos.ebservice.DetailRequestBody;
import com.kingdee.bos.ebservice.DetailRequestExt;
import com.kingdee.bos.ebservice.DetailResponseBody;
import com.kingdee.bos.ebservice.DetailResponseExt;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ws.ca.EBExtUtils;

/**
 * @author rd_jinlin_xie
 *2015-4-13
 *05:27:48
 */
public class DetailSignTextImpl extends AbstractSignTextUnit {
	
	private EBRequest request;
	private EBResponse response;
	private boolean isRequest;
	private ItrusConfigHelper helper;

	public DetailSignTextImpl(EBRequest req) {
		super(req);
		this.request = req;
		isRequest = true;
		helper = EBExtUtils.getConfigHelper();
	}
	
	public DetailSignTextImpl(EBResponse rsp) {
		super(rsp);
		this.response = rsp;
		isRequest = false;
		helper = EBExtUtils.getConfigHelper();
	}
	

	public String getRequstSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		DetailRequestBody body = (DetailRequestBody)obj;
    	StringBuffer sb = new StringBuffer();
    	sb.append("DetailRequestBody:{");
    	sb.append("startDate:").append(body.getStartDate());
    	sb.append(",endDate:").append(body.getEndDate());
    	sb.append(",pageNum:").append(body.getPageNum());
    	sb.append("}");
    	return sb.toString();
		
	}

	public String getResponseSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		DetailResponseBody body = (DetailResponseBody)obj;
    	StringBuffer sb = new StringBuffer();
    	sb.append("DetailResponseBody{");
    	Detail[] details = body.getDetails();
    	sb.append("details:[");
    	for(int i = 0 ; i < details.length ; i ++) {
    		sb.append("{");
    		sb.append("detailID:").append(details[i].getDetailID());
    		sb.append(",accNo:").append(details[i].getAccNo());
    		sb.append(",currency:").append(details[i].getCurrency());
    		sb.append(",oppAccNo:").append(details[i].getOppAccNo());
    		sb.append(",debitAmount:").append(details[i].getDebitAmount());
    		sb.append(",creditAmount:").append(details[i].getCreditAmount());
    		sb.append(",balance:").append(details[i].getBalance());
    		sb.append(",detailDateTime:").append(details[i].getDetailDateTime());
    		sb.append(",explanation:").append(details[i].getExplanation());
    		sb.append(",transType:").append(details[i].getTransType());
    		sb.append(",flowSerialNo:").append(details[i].getFlowSerialNo());
    		if(i < details.length - 1) {
    			sb.append("},");
    		} else {
    			sb.append("}");
    		}
    	}
    	sb.append("]");
    	sb.append(",pageNum:").append(body.getPageNum());
    	sb.append(",pageSize:").append(body.getPageSize());
    	sb.append(",lastPage:").append(body.getLastPage());
    	sb.append(",pagesTotalCount:").append(body.getPagesTotalCount());
    	sb.append("}");
    	return sb.toString();
		
	}

	public EBStructNode convertToEbRequestNode(Object EBRquset) {
		DetailRequestExt request = (DetailRequestExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(request.getBody());
		node.setHeader(request.getHeader());
		node.setException(null);
		return node;
		
	}

	public EBStructNode convertToEbResponseNode(Object EBRquset) {
		DetailResponseExt response = (DetailResponseExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(response.getBody());
		node.setException(response.getException());
		node.setHeader(response.getHeader());
		return node;
		
	}

	public String[] getHeaderEncodeFields() {
		if(isRequest) {
			return helper.getDetailRequestHeaderEncodeFields();
		}
		
		return helper.getDetailResponseHeaderEncodeFields();
		
	}

	public String[] getBodyEncodeFields() {
		String[] result = null;
		if(isRequest) {
			result = helper.getDetailRequestBodyEncodeFields();
		} else {
			result = helper.getDetailResponseBodyEncodeFields();
		}
		return result;
		
	}

	public String[] getOtherEncodeFields() {
		if(isRequest) {
			return helper.getDetailRequestDetailEncodeFields();
		}
		return helper.getDetailResponseDetailEncodeFields();
		
	}

	public EBHeader getHeader() {
		
		if(null != request) {
			return request.getHeader();
		}
		
		if(null != response) {
			return response.getHeader();
		}
		return null;
		
	}

	public Object getBody() {
		if(null != request) {
			return ((DetailRequestExt)request).getBody();
		}
		
		if(null != response) {
			return ((DetailResponseExt)response).getBody();
		}
		return null;
		
	}

	public Object[] getDetails() {
		if(null != request) {
			return null;
		}
		
		if(null != response) {
			DetailResponseBody body = ((DetailResponseExt)response).getBody();
			if(null == body) {
				return null;
			}
			return body.getDetails();
		}
		return null;
		
	}

}
