/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.LinkPayDetail;
import com.kingdee.bos.ebservice.QueryLinkPayRequestBody;
import com.kingdee.bos.ebservice.QueryLinkPayRequestExt;
import com.kingdee.bos.ebservice.QueryLinkPayResponseBody;
import com.kingdee.bos.ebservice.QueryLinkPayResponseExt;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ws.ca.EBExtUtils;

/**
 * @author rd_jinlin_xie
 *2015-4-14
 *10:08:54
 */
public class QueryLinkPaySignTextImpl extends AbstractSignTextUnit{
	
	private EBRequest request;
	private EBResponse response;
	private boolean isRequest;
	private ItrusConfigHelper helper;

	public QueryLinkPaySignTextImpl(EBRequest req) {
		super(req);
		this.request = req;
		isRequest = true;
		helper = EBExtUtils.getConfigHelper();
	}
	
	public QueryLinkPaySignTextImpl(EBResponse rsp) {
		super(rsp);
		this.response = rsp;
		isRequest = false;
		helper = EBExtUtils.getConfigHelper();
	}
	

	public String getRequstSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		QueryLinkPayRequestBody body = (QueryLinkPayRequestBody)obj;
				
		return "QueryLinkPayRequestBody:{batchSeqID:" + body.getBatchSeqID() + "}";
		
	}

	public String getResponseSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		QueryLinkPayResponseBody body = (QueryLinkPayResponseBody)obj;
		StringBuffer sb = new StringBuffer();
		sb.append("QueryLinkPayResponseBody:{");
		sb.append("status:").append(body.getStatus());
		sb.append(",statusMsg:").append(body.getStatusMsg());
		sb.append(",linkPayDetails:[");
		sb.append(genLinkPayDetailText(body.getLinkPayDetails()));
		sb.append("]");
		sb.append("}");
		return sb.toString();
		
	}

	public EBStructNode convertToEbRequestNode(Object EBRquset) {
		QueryLinkPayRequestExt request = (QueryLinkPayRequestExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(request.getBody());
		node.setHeader(request.getHeader());
		node.setException(null);
		return node;
		
	}

	public EBStructNode convertToEbResponseNode(Object EBRquset) {
		QueryLinkPayResponseExt response = (QueryLinkPayResponseExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(response.getBody());
		node.setHeader(response.getHeader());
		node.setException(response.getException());
		return node;
	}

	private String genLinkPayDetailText(LinkPayDetail[] details) {
		StringBuffer sb = new StringBuffer();
		if(details.length > 0) {
			for(int i = 0 ; i < details.length ; i ++) {
				sb.append("LinkPayDetail:{");
				sb.append("payerAccNo:").append(details[i].getPayerAccNo());
				sb.append("type:").append(details[i].getType());
				//ƴPaymentDetailϢ
				sb.append(details[i].getDetailSeqID() + ",detailBizNo:"
				+ details[i].getDetailBizNo() + ",payeeAccNo:"
				+ details[i].getPayeeAccNo() + ",payeeAccName:"
				+ details[i].getPayeeAccName() + ",payeeType:"
				+ details[i].getPayeeType() + ",payeeBankName:"
				+ details[i].getPayeeBankName() + ",payeeBankAddr:"
				+ details[i].getPayeeBankAddr() + ",payeeCountry:"
				+ details[i].getPayeeCountry() + ",payeeProvince:"
				+ details[i].getPayeeProvince() + ",payeeCity:"
				+ details[i].getPayeeCity() + ",payeeAreaCode:"
				+ details[i].getPayeeAreaCode() + ",payeeCnapsCode:"
				+ details[i].getPayeeCnapsCode() + ",payeeSwiftCode:"
				+ details[i].getPayeeSwiftCode() + ",amount:"
				+ details[i].getAmount() + ",bookingDate:"
				+ details[i].getBookingDate() + ",urgent:"
				+ details[i].getUrgent() + ",forceManual:"
				+ details[i].getForceManual() + ",useCode:"
				+ details[i].getUseCode() + ",use:" + details[i].getUse()
				+ ",desc:" + details[i].getDesc() + ",mobile:"
				+ details[i].getMobile() + ",email:" + details[i].getEmail()
				+ ",verifyField:" + details[i].getVerifyField() + ",ebSeqID:"
				+ details[i].getEbSeqID() + ",ebStatus:"
				+ details[i].getEbStatus() + ",ebStatusMsg:"
				+ details[i].getEbStatusMsg() + ",bankBatchSeqID:"
				+ details[i].getBankBatchSeqID() + ",bankStatus:"
				+ details[i].getBankStatus() + ",bankStatusMsg:"
				+ details[i].getBankStatusMsg());
				if(i < details.length - 1) {
					sb.append("},");
				} else {
					sb.append("}");
				}
			}
		}
		return sb.toString();
	}

	public String[] getHeaderEncodeFields() {
		if(isRequest) {
			return helper.getQueryLinkPayRequestHeaderEncodeFields();
		}
		return helper.getQueryLinkPayResponseHeaderEncodeFields();
		
	}

	public String[] getBodyEncodeFields() {
		if(isRequest) {
			return helper.getQueryLinkPayRequestBodyEncodeFields();
		}
		return helper.getQueryLinkPayResponseBodyEncodeFields();
		
	}

	public String[] getOtherEncodeFields() {
		if(isRequest) {
			return helper.getQueryLinkPayRequestDetailEncodeFields();
		}
		return helper.getQueryLinkPayResponseDetailEncodeFields();
		
	}

	public EBHeader getHeader() {

		if(null != request) {
			return request.getHeader();
		}
		
		if(null != response) {
			return response.getHeader();
		}
		return null;
		
	}

	public Object getBody() {

		if(null != request) {
			return ((QueryLinkPayRequestExt)request).getBody();
		}
		
		if(null != response) {
			return ((QueryLinkPayResponseExt)response).getBody();
		}
		return null;
		
	}

	public Object[] getDetails() {
		if(null != request) {
			return null;
		}
		
		if(null != response) {
			QueryLinkPayResponseBody body = ((QueryLinkPayResponseExt)response).getBody();
			if(null == body) {
				return null;
			}
			return body.getLinkPayDetails();
		}
		return null;
		
	}
}
