/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class ApplyExpression
extends Expression {
    protected Expression expression;
    protected Expression[] arguments;

    protected ApplyExpression(Expression expression, Expression[] arguments) {
        super(ExpressionType.APPLY);
        this.expression = expression;
        this.arguments = arguments;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression[] getArguments() {
        return (Expression[])this.arguments.clone();
    }

    protected ELNode toInternal() {
        ELNode[] args = new ELNode[this.arguments.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.arguments[i].getNode();
        }
        return new ELNode.APPLY(0, this.expression.getNode(), args, null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.expression);
        buf.append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.arguments[i]);
        }
        buf.append(")");
        return buf.toString();
    }
}

