/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class BinaryExpression
extends Expression {
    protected Expression left;
    protected Expression right;

    protected BinaryExpression(ExpressionType nodeType, Expression left, Expression right) {
        super(nodeType);
        this.left = left;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    protected ELNode toInternal() {
        ELNode lhs = this.left.getNode();
        ELNode rhs = this.right.getNode();
        switch (this.nodeType) {
            case ADD: {
                return new ELNode.ADD(0, lhs, rhs);
            }
            case AND: {
                return new ELNode.AND(0, lhs, rhs);
            }
            case ASSIGN: {
                return new ELNode.ASSIGN(0, lhs, rhs);
            }
            case BITWISE_AND: {
                return new ELNode.BITAND(0, lhs, rhs);
            }
            case BITWISE_OR: {
                return new ELNode.BITOR(0, lhs, rhs);
            }
            case COALESCE: {
                return new ELNode.COALESCE(0, lhs, rhs);
            }
            case DIVIDE: {
                return new ELNode.DIV(0, lhs, rhs);
            }
            case EQUAL: {
                return new ELNode.EQ(0, lhs, rhs);
            }
            case GREATER_THAN: {
                return new ELNode.GT(0, lhs, rhs);
            }
            case GREATER_THAN_OR_EQUAL: {
                return new ELNode.GE(0, lhs, rhs);
            }
            case IN: {
                return new ELNode.IN(0, lhs, rhs, false);
            }
            case INSTANCEOF: {
                return new ELNode.INSTANCEOF(0, lhs, ((ELNode.STRINGVAL)rhs).value, false);
            }
            case LEFT_SHIFT: {
                return new ELNode.SHL(0, lhs, rhs);
            }
            case LESS_THAN: {
                return new ELNode.LT(0, lhs, rhs);
            }
            case LESS_THAN_OR_EQUAL: {
                return new ELNode.LE(0, lhs, rhs);
            }
            case MULTIPLY: {
                return new ELNode.MUL(0, lhs, rhs);
            }
            case NOT_EQUAL: {
                return new ELNode.NE(0, lhs, rhs);
            }
            case OR: {
                return new ELNode.OR(0, lhs, rhs);
            }
            case POWER: {
                return new ELNode.POW(0, lhs, rhs);
            }
            case REMAINDER: {
                return new ELNode.REM(0, lhs, rhs);
            }
            case RIGHT_SHIFT: {
                return new ELNode.SHR(0, lhs, rhs);
            }
            case SAFEREF: {
                return new ELNode.SAFEREF(0, lhs, rhs);
            }
            case SUBTRACT: {
                return new ELNode.SUB(0, lhs, rhs);
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return new ELNode.USHR(0, lhs, rhs);
            }
            case XOR: {
                return new ELNode.XOR(0, lhs, rhs);
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        ELNode.Binary node = (ELNode.Binary)this.getNode();
        StringBuilder buf = new StringBuilder();
        if (node.left.precedence() < node.precedence()) {
            buf.append("(").append(this.left).append(")");
        } else {
            buf.append(this.left);
        }
        buf.append(this.nodeType.getOp());
        if (node.right.precedence() < node.precedence()) {
            buf.append("(").append(this.right).append(")");
        } else {
            buf.append(this.right);
        }
        return buf.toString();
    }
}

