/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class NewExpression
extends Expression {
    protected String type;
    protected Expression[] arguments;

    protected NewExpression(String type, Expression[] arguments) {
        super(ExpressionType.NEW);
        this.type = type;
        this.arguments = arguments;
    }

    public String getType() {
        return this.type;
    }

    public Expression[] getArguments() {
        return (Expression[])this.arguments.clone();
    }

    protected ELNode toInternal() {
        ELNode[] args = new ELNode[this.arguments.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.arguments[i].getNode();
        }
        return new ELNode.NEW(0, this.type, args, null, null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(this.type);
        buf.append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.arguments[i]);
        }
        buf.append(")");
        return buf.toString();
    }
}

