/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class UnaryExpression
extends Expression {
    protected Expression operand;

    protected UnaryExpression(ExpressionType nodeType, Expression operand) {
        super(nodeType);
        this.operand = operand;
    }

    public Expression getOperand() {
        return this.operand;
    }

    protected ELNode toInternal() {
        ELNode rhs = this.operand.getNode();
        switch (this.nodeType) {
            case NOT: {
                return new ELNode.NOT(0, rhs);
            }
            case BITWISE_NOT: {
                return new ELNode.BITNOT(0, rhs);
            }
            case NEGATE: {
                return new ELNode.NEG(0, rhs);
            }
            case UNARY_PLUS: {
                return new ELNode.POS(0, rhs);
            }
            case PARENTHESIS: {
                return new ELNode.EXPR(0, rhs);
            }
            case POST_INCREMENT: {
                return new ELNode.INC(0, rhs, false);
            }
            case POST_DECREMENT: {
                return new ELNode.DEC(0, rhs, false);
            }
            case PRE_INCREMENT: {
                return new ELNode.INC(0, rhs, true);
            }
            case PRE_DECREMENT: {
                return new ELNode.DEC(0, rhs, true);
            }
            case EMPTY: {
                return new ELNode.EMPTY(0, rhs);
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        switch (this.nodeType) {
            case NOT: {
                return "!" + this.operand;
            }
            case BITWISE_NOT: {
                return "~" + this.operand;
            }
            case NEGATE: {
                return "-" + this.operand;
            }
            case UNARY_PLUS: {
                return "+" + this.operand;
            }
            case PARENTHESIS: {
                return "(" + this.operand + ")";
            }
            case POST_INCREMENT: {
                return this.operand + "++";
            }
            case POST_DECREMENT: {
                return this.operand + "--";
            }
            case PRE_INCREMENT: {
                return "++" + this.operand;
            }
            case PRE_DECREMENT: {
                return "--" + this.operand;
            }
            case EMPTY: {
                return "empty " + this.operand;
            }
        }
        throw new IllegalArgumentException();
    }
}

