/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.Decimal;
import elite.lang.MathLib;
import elite.lang.annotation.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.operamasks.el.eval.TypeCoercion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Constructor(value={"numerator", "denominator"})
public final class Rational
extends Number
implements Comparable<Rational> {
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE);
    public static final Rational POSITIVE_INFINITY = new Rational(BigInteger.ONE, BigInteger.ZERO);
    public static final Rational NEGATIVE_INFINITY = new Rational(BigInteger.ONE.negate(), BigInteger.ZERO);
    private BigInteger numer;
    private BigInteger denom;
    private static final int CHUNK = 28;

    private Rational(BigInteger numer, BigInteger denom) {
        this.numer = numer;
        this.denom = denom;
    }

    public static Rational valueOf(Number numer, Number denom) {
        if (numer instanceof BigInteger) {
            if (denom instanceof BigInteger) {
                return Rational.make((BigInteger)numer, (BigInteger)denom);
            }
            return Rational.make((BigInteger)numer, TypeCoercion.coerceToBigInteger(denom));
        }
        if (denom instanceof BigInteger) {
            return Rational.make(TypeCoercion.coerceToBigInteger(numer), (BigInteger)denom);
        }
        return Rational.make(numer.longValue(), denom.longValue());
    }

    public static Rational valueOf(Number val) {
        if (val instanceof BigDecimal) {
            return Rational.valueOf((BigDecimal)val);
        }
        if (val instanceof Decimal) {
            return Rational.valueOf((Decimal)val);
        }
        if (val instanceof BigInteger) {
            return new Rational((BigInteger)val, BigInteger.ONE);
        }
        if (val instanceof Rational) {
            return (Rational)val;
        }
        if (val instanceof Double || val instanceof Float) {
            return Rational.valueOf(val.doubleValue());
        }
        return Rational.make(val.longValue(), 1L);
    }

    public static Rational valueOf(String str) {
        int sep = str.indexOf(47);
        if (sep >= 0) {
            BigInteger numer = new BigInteger(str.substring(0, sep));
            BigInteger denom = new BigInteger(str.substring(sep + 1));
            return new Rational(numer, denom).normalize();
        }
        return new Rational(new BigInteger(str), BigInteger.ONE);
    }

    public static Rational make(BigInteger numer, BigInteger denom) {
        return new Rational(numer, denom).normalize();
    }

    public static Rational make(long numer, long denom) {
        long g;
        if (denom == 0L) {
            return numer >= 0L ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (numer == 0L) {
            return ZERO;
        }
        if (numer == denom) {
            return ONE;
        }
        if (denom < 0L) {
            numer = -numer;
            denom = -denom;
        }
        if ((g = Rational.gcd(numer, denom)) != 1L) {
            numer /= g;
            denom /= g;
        }
        return new Rational(BigInteger.valueOf(numer), BigInteger.valueOf(denom));
    }

    private static long gcd(long m, long n) {
        if (m < 0L) {
            m = -m;
        }
        if (n < 0L) {
            n = -n;
        }
        while (n > 0L) {
            long r = m % n;
            m = n;
            n = r;
        }
        return m;
    }

    private static Rational valueOf(double x) {
        if (x == 0.0) {
            return new Rational(BigInteger.ZERO, BigInteger.ONE);
        }
        if (x == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        boolean neg = false;
        if (x < 0.0) {
            x = -x;
            neg = true;
        }
        double[] t = MathLib.frexp(x);
        double f = t[0];
        int e = (int)t[1];
        BigInteger top = BigInteger.ZERO;
        BigInteger bot = BigInteger.ONE;
        while (f != 0.0) {
            f = MathLib.ldexp(f, 28);
            int digit = (int)f;
            top = top.shiftLeft(28).add(BigInteger.valueOf(digit));
            f -= (double)digit;
            e -= 28;
        }
        if (e > 0) {
            top = top.shiftLeft(e);
        } else {
            bot = bot.shiftLeft(-e);
        }
        if (neg) {
            top = top.negate();
        }
        return Rational.make(top, bot);
    }

    private static Rational valueOf(BigDecimal val) {
        BigInteger d;
        BigInteger n;
        int scale = val.scale();
        if (scale == 0) {
            n = val.unscaledValue();
            d = BigInteger.ONE;
        } else if (scale > 0) {
            n = val.unscaledValue();
            d = BigInteger.TEN.pow(scale);
        } else {
            n = val.unscaledValue().multiply(BigInteger.TEN.pow(-scale));
            d = BigInteger.ONE;
        }
        return Rational.make(n, d);
    }

    private static Rational valueOf(Decimal val) {
        int scale = val.scale();
        BigInteger n = BigInteger.valueOf(val.unscaledValue());
        BigInteger d = BigInteger.valueOf(10L).pow(scale);
        return Rational.make(n, d);
    }

    public BigInteger getNumerator() {
        return this.numer;
    }

    public BigInteger getDenominator() {
        return this.denom;
    }

    public Rational add(Rational that) {
        return Rational.make(this.numer.multiply(that.denom).add(this.denom.multiply(that.numer)), this.denom.multiply(that.denom));
    }

    public Rational subtract(Rational that) {
        return Rational.make(this.numer.multiply(that.denom).subtract(this.denom.multiply(that.numer)), this.denom.multiply(that.denom));
    }

    public Rational multiply(Rational that) {
        return Rational.make(this.numer.multiply(that.numer), this.denom.multiply(that.denom));
    }

    public Rational divide(Rational that) {
        return Rational.make(this.numer.multiply(that.denom), this.denom.multiply(that.numer));
    }

    public Rational remainder(Rational that) {
        Rational[] divrem = this.divideAndRemainder(that);
        return divrem[1];
    }

    public Rational[] divideAndRemainder(Rational that) {
        BigInteger n = that.numer;
        BigInteger d = that.denom;
        BigInteger i = this.numer.multiply(d).divide(this.denom.multiply(n));
        Rational[] result = new Rational[]{Rational.make(i, BigInteger.ONE), this.subtract(Rational.make(that.numer.multiply(i), that.denom))};
        return result;
    }

    public Rational gcd(Rational that) {
        if (that.signum() == 0) {
            return this.abs();
        }
        if (this.signum() == 0) {
            return that.abs();
        }
        Rational a = this.abs();
        Rational b = that.abs();
        while (b.signum() != 0) {
            Rational r = a.remainder(b);
            a = b;
            b = r;
        }
        return a;
    }

    public Rational pow(int n) {
        if (n < 0) {
            return Rational.make(this.denom.pow(-n), this.numer.pow(-n));
        }
        return Rational.make(this.numer.pow(n), this.denom.pow(n));
    }

    public Rational negate() {
        return new Rational(this.numer.negate(), this.denom);
    }

    public int signum() {
        return this.numer.signum();
    }

    public Rational abs() {
        return this.numer.signum() >= 0 ? this : new Rational(this.numer.negate(), this.denom);
    }

    public BigInteger toBigInteger() {
        return this.numer.divide(this.denom);
    }

    @Override
    public long longValue() {
        return this.numer.divide(this.denom).longValue();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public short shortValue() {
        return (short)this.longValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.longValue();
    }

    @Override
    public double doubleValue() {
        int denomBitLength;
        if (this.numer.signum() < 0) {
            return -this.abs().doubleValue();
        }
        int numerBitLength = this.numer.bitLength();
        if (numerBitLength > (denomBitLength = this.denom.bitLength())) {
            int shift = denomBitLength - 63;
            long divisor = this.denom.shiftRight(shift).longValue();
            BigInteger dividend = this.numer.shiftRight(shift);
            return dividend.doubleValue() / (double)divisor;
        }
        int shift = numerBitLength - 63;
        long dividend = this.numer.shiftRight(shift).longValue();
        BigInteger divisor = this.denom.shiftRight(shift);
        return (double)dividend / divisor.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public BigDecimal toBigDecimal() {
        BigDecimal n = new BigDecimal(this.numer);
        BigDecimal d = new BigDecimal(this.denom);
        MathContext mc = new MathContext((int)Math.min((long)n.precision() + (long)Math.ceil(10.0 * (double)d.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.HALF_EVEN);
        return n.divide(d, mc);
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        return new BigDecimal(this.numer).divide(new BigDecimal(this.denom), mc);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rational) {
            Rational that = (Rational)obj;
            return this.numer.equals(that.numer) && this.denom.equals(that.denom);
        }
        return false;
    }

    public int hashCode() {
        return this.numer.hashCode() ^ this.denom.hashCode();
    }

    public String toString() {
        if (this.denom.signum() == 0) {
            return this.numer.signum() >= 0 ? "Infinity" : "-Infinity";
        }
        if (this.denom.equals(BigInteger.ONE)) {
            return this.numer.toString();
        }
        return this.numer.toString().concat("/").concat(this.denom.toString());
    }

    @Override
    public int compareTo(Rational that) {
        return this.numer.multiply(that.denom).compareTo(that.numer.multiply(this.denom));
    }

    private Rational normalize() {
        BigInteger gcd;
        if (this.denom.signum() == 0) {
            return this.numer.signum() >= 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        if (this.denom.signum() < 0) {
            this.numer = this.numer.negate();
            this.denom = this.denom.negate();
        }
        if (!(gcd = this.numer.gcd(this.denom)).equals(BigInteger.ONE)) {
            this.numer = this.numer.divide(gcd);
            this.denom = this.denom.divide(gcd);
        }
        return this;
    }

    public Number reduce() {
        if (this.numer.signum() == 0) {
            return 0;
        }
        if (this.denom.equals(BigInteger.ONE)) {
            return this.numer.bitLength() < 32 ? (Number)this.numer.intValue() : (Number)(this.numer.bitLength() < 64 ? Long.valueOf(this.numer.longValue()) : this.numer);
        }
        return this;
    }
}

