/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Symbol
implements Serializable,
Comparable<Symbol> {
    private static final Table GLOBAL_TABLE = new Table();
    final String name;
    final int hash;
    transient Symbol next;

    public static Symbol valueOf(String name) {
        return GLOBAL_TABLE.getSymbol(name);
    }

    Symbol(String name, int hash, Symbol next) {
        this.name = name;
        this.hash = hash;
        this.next = next;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Symbol that) {
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return ":" + this.name;
    }

    private Object readResolve() {
        return Symbol.valueOf(this.name);
    }

    public static class Table {
        static final int DEFAULT_INITIAL_CAPACITY = 2048;
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private volatile Symbol[] table = new Symbol[2048];
        private int size;
        private int threshold = 1536;
        private float loadFactor = 0.75f;

        private static int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }

        public Symbol getSymbol(String name) {
            Symbol[] table = this.table;
            int hash = Table.hash(name.hashCode());
            int i = hash & table.length - 1;
            Symbol e = table[i];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    return e;
                }
                e = e.next;
            }
            return this.addSymbol(name, hash);
        }

        private synchronized Symbol addSymbol(String name, int hash) {
            Symbol s;
            Symbol[] table = this.table;
            int i = hash & table.length - 1;
            Symbol e = table[i];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    return e;
                }
                e = e.next;
            }
            table[i] = s = new Symbol(name, hash, table[i]);
            if (this.size++ >= this.threshold) {
                this.rehash(table.length * 2);
            }
            return s;
        }

        private void rehash(int newCapacity) {
            Symbol[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            Symbol[] newTable = new Symbol[newCapacity];
            this.transfer(newTable);
            this.table = newTable;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        }

        private void transfer(Symbol[] newTable) {
            Symbol[] src = this.table;
            int newCapacity = newTable.length;
            for (int j = 0; j < src.length; ++j) {
                Symbol next;
                Symbol e = src[j];
                if (e == null) continue;
                src[j] = null;
                do {
                    next = e.next;
                    int i = e.hash & newCapacity - 1;
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
        }
    }
}

