/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.Timestamp;
import elite.lang.annotation.Expando;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSpan
implements Serializable,
Comparable<TimeSpan> {
    private final long time;
    public static final TimeSpan ZERO = new TimeSpan(0L);
    public static final TimeSpan ONE_DAY = new TimeSpan(1, 0, 0, 0);
    public static final TimeSpan ONE_HOUR = new TimeSpan(0, 1, 0, 0);
    public static final TimeSpan ONE_MINUTE = new TimeSpan(0, 0, 1, 0);
    public static final TimeSpan ONE_SECOND = new TimeSpan(0, 0, 0, 1);
    private static final long DAY_AMOUNT = 86400000L;
    private static final long HOUR_AMOUNT = 3600000L;
    private static final long MINUTE_AMOUNT = 60000L;
    private static final long SECOND_AMOUNT = 1000L;

    public TimeSpan() {
        this.time = 0L;
    }

    public TimeSpan(long time) {
        this.time = time;
    }

    public TimeSpan(int days, int hours, int minutes, int seconds) {
        this.time = (seconds + 60 * (minutes + 60 * (hours + 24 * days))) * 1000;
    }

    public static TimeSpan difference(Timestamp time1, Timestamp time2) {
        return new TimeSpan(time1.getTimeInMillis() - time2.getTimeInMillis());
    }

    public static TimeSpan dateDifference(Timestamp date1, Timestamp date2) {
        Timestamp adjDate1 = new Timestamp(date1.getYear(), date1.getMonth(), date1.getDate());
        Timestamp adjDate2 = new Timestamp(date2.getYear(), date2.getMonth(), date2.getDate());
        return TimeSpan.difference(adjDate1, adjDate2);
    }

    public static TimeSpan timeDifference(Timestamp time1, Timestamp time2) {
        Timestamp adjTime1 = new Timestamp(0, 0, 0, time1.getHours(), time1.getMinutes(), time1.getSeconds());
        Timestamp adjTime2 = new Timestamp(0, 0, 0, time2.getHours(), time2.getMinutes(), time2.getSeconds());
        return TimeSpan.difference(adjTime1, adjTime2);
    }

    public long getDays() {
        return this.time / 86400000L;
    }

    public long getTotalHours() {
        return this.time / 3600000L;
    }

    public int getHours() {
        return (int)(this.getTotalHours() - this.getDays() * 24L);
    }

    public long getTotalMinutes() {
        return this.time / 60000L;
    }

    public int getMinutes() {
        return (int)(this.getTotalMinutes() - this.getTotalHours() * 60L);
    }

    public long getTotalSeconds() {
        return this.time / 1000L;
    }

    public int getSeconds() {
        return (int)(this.getTotalSeconds() - this.getTotalMinutes() * 60L);
    }

    public long getTotalMilliSeconds() {
        return this.time;
    }

    public int getMilliSeconds() {
        return (int)(this.getTotalMilliSeconds() - this.getTotalSeconds() * 1000L);
    }

    @Override
    public int compareTo(TimeSpan span) {
        long diff = this.time - span.getTotalMilliSeconds();
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }

    @Expando(name="+")
    public TimeSpan add(TimeSpan span) {
        return new TimeSpan(this.time + span.getTotalMilliSeconds());
    }

    @Expando(name="-")
    public TimeSpan subtract(TimeSpan span) {
        return new TimeSpan(this.time - span.getTotalMilliSeconds());
    }

    @Expando(name="__pos__")
    public TimeSpan __pos__() {
        return this;
    }

    @Expando(name="__neg__")
    public TimeSpan negate() {
        return new TimeSpan(-this.time);
    }

    public int signum() {
        return this.time == 0L ? 0 : (this.time > 0L ? 1 : -1);
    }

    public String format(String mask) {
        StringBuilder result = new StringBuilder();
        if (this.time < 0L) {
            result.append("-");
        }
        int length = mask.length();
        block6: for (int i = 0; i < length; ++i) {
            char c = mask.charAt(i);
            if (c != '%') {
                result.append(c);
                continue;
            }
            c = mask.charAt(++i);
            switch (c) {
                case 'd': {
                    result.append(Math.abs(this.getDays()));
                    continue block6;
                }
                case 'h': {
                    result.append(Math.abs(this.getHours()));
                    continue block6;
                }
                case 'm': {
                    result.append(Math.abs(this.getMinutes()));
                    continue block6;
                }
                case 's': {
                    result.append(Math.abs(this.getSeconds()));
                    continue block6;
                }
                default: {
                    result.append('%');
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof TimeSpan && this.time == ((TimeSpan)obj).getTotalMilliSeconds();
    }

    public int hashCode() {
        return (int)(this.time ^ (long)((int)(this.time >>> 32)));
    }

    public String toString() {
        return this.format("%d %h:%m:%s");
    }
}

