/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.lang.Closure;
import elite.xml.VirtualNode;
import elite.xml.XmlNode;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterVirtualNode
extends VirtualNode
implements Iterable<XmlNode> {
    protected final Iterable<XmlNode> scope;
    protected final Closure filter;
    protected XmlNode real;

    FilterVirtualNode(XmlNode parent, Iterable<XmlNode> scope, Closure filter) {
        super(parent, null);
        this.scope = scope;
        this.filter = filter;
    }

    @Override
    protected XmlNode realize(boolean create) {
        if (this.real == null) {
            for (XmlNode node : this.scope) {
                if (!this.filter.test(null, node)) continue;
                this.real = node;
                return this.real;
            }
        }
        return this.real;
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        if (property instanceof String) {
            return super.getValue(elctx, property);
        }
        if (property instanceof Number) {
            int index = ((Number)property).intValue();
            Iterator<XmlNode> it = this.scope.iterator();
            while (index >= 0 && it.hasNext()) {
                XmlNode node = it.next();
                if (!this.filter.test(elctx, node) || index-- != 0) continue;
                elctx.setPropertyResolved(true);
                return node;
            }
            return null;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        if (property instanceof String) {
            return super.getType(elctx, property);
        }
        if (property instanceof Number) {
            elctx.setPropertyResolved(true);
            return XmlNode.class;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        if (property instanceof String) {
            return super.isReadOnly(elctx, property);
        }
        if (property instanceof Number) {
            elctx.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        if (property instanceof String) {
            super.setValue(elctx, property, value);
        } else if (property instanceof Number) {
            throw new PropertyNotWritableException(Resources._T("EL_PROPERTY_NOT_WRITABLE", "XmlNode", property));
        }
    }

    public XmlNode filter(Closure pred) {
        return new FilterVirtualNode(this.parent, this, pred);
    }

    @Override
    public Iterator<XmlNode> iterator() {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        for (XmlNode node : this.scope) {
            if (!this.filter.test(null, node)) continue;
            list.add(node);
        }
        return list.iterator();
    }
}

