/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Decimal;
import elite.lang.Range;
import elite.lang.Rational;
import elite.lang.Seq;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.seq.ArraySeq;
import org.operamasks.el.eval.seq.IteratorSeq;
import org.operamasks.el.eval.seq.ListSeq;
import org.operamasks.el.eval.seq.PArraySeq;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class Coercion {
    private static Map<Class, Integer> typeMap = new IdentityHashMap<Class, Integer>();
    public static final int NULL_TYPE = 0;
    public static final int BOOLEAN_PRIMITIVE_TYPE = 1;
    public static final int BOOLEAN_BOXED_TYPE = 2;
    public static final int BYTE_PRIMITIVE_TYPE = 3;
    public static final int BYTE_BOXED_TYPE = 4;
    public static final int CHAR_PRIMITIVE_TYPE = 5;
    public static final int CHAR_BOXED_TYPE = 6;
    public static final int SHORT_PRIMITIVE_TYPE = 7;
    public static final int SHORT_BOXED_TYPE = 8;
    public static final int INT_PRIMITIVE_TYPE = 9;
    public static final int INT_BOXED_TYPE = 10;
    public static final int LONG_PRIMITIVE_TYPE = 11;
    public static final int LONG_BOXED_TYPE = 12;
    public static final int FLOAT_PRIMITIVE_TYPE = 13;
    public static final int FLOAT_BOXED_TYPE = 14;
    public static final int DOUBLE_PRIMITIVE_TYPE = 15;
    public static final int DOUBLE_BOXED_TYPE = 16;
    public static final int STRING_TYPE = 17;
    public static final int BIG_DECIMAL_TYPE = 18;
    public static final int BIG_INTEGER_TYPE = 19;
    public static final int ENUM_TYPE = 20;
    public static final int OBJECT_TYPE = 21;
    public static final int DECIMAL_TYPE = 22;
    public static final int RATIONAL_TYPE = 23;
    public static final int UNKNOWN_TYPE = 24;

    public static int typeof(Class<?> t) {
        if (t == null) {
            return 0;
        }
        Integer type = typeMap.get(t);
        if (type != null) {
            return type;
        }
        if (t.isEnum()) {
            return 20;
        }
        return 24;
    }

    public static int typeof(Object o) {
        if (o == null) {
            return 0;
        }
        Integer type = typeMap.get(o.getClass());
        if (type != null) {
            return type;
        }
        if (Enum.class.isInstance(o)) {
            return 20;
        }
        return 24;
    }

    public static String coerceToString(Object v) {
        if (v == null) {
            return "";
        }
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof Range) {
            return v.toString();
        }
        if (v instanceof Collection) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            Iterator i = ((Collection)v).iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Coercion.to_s(buf, v, i.next());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }
        if (v instanceof Map) {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            Iterator i = ((Map)v).entrySet().iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Map.Entry e = i.next();
                Coercion.to_s(buf, v, e.getKey());
                buf.append(":");
                Coercion.to_s(buf, v, e.getValue());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            for (int i = 0; i < length; ++i) {
                Coercion.to_s(buf, v, Array.get(v, i));
                if (i >= length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
            return buf.toString();
        }
        return v.toString();
    }

    private static void to_s(StringBuilder buf, Object v, Object o) {
        if (o == v) {
            buf.append("(this object)");
        } else if (o instanceof String) {
            Coercion.escape(buf, (String)o);
        } else {
            buf.append(Coercion.coerceToString(o));
        }
    }

    public static void escape(StringBuilder buf, String s) {
        boolean escaped = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            String esc = null;
            switch (c) {
                case '\r': {
                    esc = "\\r";
                    break;
                }
                case '\n': {
                    esc = "\\n";
                    break;
                }
                case '\f': {
                    esc = "\\f";
                    break;
                }
                case '\b': {
                    esc = "\\b";
                    break;
                }
                case '\t': {
                    esc = "\\t";
                    break;
                }
                case '\\': {
                    esc = "\\\\";
                    break;
                }
                case '\'': {
                    esc = "'";
                    break;
                }
                case '\"': {
                    esc = "\\\"";
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    esc = "\\00" + Integer.toOctalString(c);
                    break;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    esc = "\\0" + Integer.toOctalString(c);
                }
            }
            if (esc != null) {
                if (!escaped) {
                    buf.append('\"');
                    buf.append(s.substring(0, i));
                    escaped = true;
                }
                buf.append(esc);
                continue;
            }
            if (!escaped) continue;
            buf.append(c);
        }
        if (escaped) {
            buf.append('\"');
        } else {
            buf.append('\'');
            buf.append(s);
            buf.append('\'');
        }
    }

    public static Decimal coerceToDecimal(Object v) throws ELException {
        if (v == null) {
            return Decimal.ZERO;
        }
        if (v instanceof Decimal) {
            return (Decimal)v;
        }
        if (v instanceof BigDecimal) {
            return Decimal.valueOf((BigDecimal)v);
        }
        if (v instanceof BigInteger) {
            return Decimal.valueOf(new BigDecimal((BigInteger)v));
        }
        if (v instanceof Number) {
            return Decimal.valueOf(((Number)v).doubleValue());
        }
        if (v instanceof Character) {
            return Decimal.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Decimal.ZERO;
            }
            return Decimal.valueOf(s);
        }
        throw Coercion.coerceError(v, "Decimal");
    }

    public static Rational coerceToRational(Object v) {
        if (v == null) {
            return Rational.ZERO;
        }
        if (v instanceof Rational) {
            return (Rational)v;
        }
        if (v instanceof BigInteger) {
            return Rational.make((BigInteger)v, BigInteger.ONE);
        }
        if (v instanceof BigDecimal) {
            return Rational.valueOf((Number)((BigDecimal)v));
        }
        if (v instanceof Decimal) {
            return Rational.valueOf((Number)((Decimal)v));
        }
        if (v instanceof Double || v instanceof Float) {
            return Rational.valueOf((Number)((Number)v).doubleValue());
        }
        if (v instanceof Number) {
            return Rational.make(((Number)v).longValue(), 1L);
        }
        if (v instanceof Character) {
            return Rational.make((short)((Character)v).charValue(), 1L);
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Rational.ZERO;
            }
            return Rational.valueOf(s);
        }
        throw Coercion.coerceError(v, "Rational");
    }

    public static BigDecimal coerceToBigDecimal(Object v) throws ELException {
        if (v == null) {
            return BigDecimal.valueOf(0L);
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)v);
        }
        if (v instanceof Decimal) {
            return ((Decimal)v).toBigDecimal();
        }
        if (v instanceof Rational) {
            return ((Rational)v).toBigDecimal();
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)v).doubleValue());
        }
        if (v instanceof Character) {
            return BigDecimal.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(s);
        }
        throw Coercion.coerceError(v, "BigDecimal");
    }

    public static BigDecimal coerceToBigDecimal(Object v, MathContext mc) {
        if (v == null) {
            return BigDecimal.valueOf(0L);
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)v, mc);
        }
        if (v instanceof Decimal) {
            return ((Decimal)v).toBigDecimal();
        }
        if (v instanceof Rational) {
            return ((Rational)v).toBigDecimal(mc);
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)v).doubleValue(), mc);
        }
        if (v instanceof Character) {
            return BigDecimal.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(s, mc);
        }
        throw Coercion.coerceError(v, "BigDecimal");
    }

    public static BigInteger coerceToBigInteger(Object v) throws ELException {
        if (v == null) {
            return BigInteger.valueOf(0L);
        }
        if (v instanceof BigInteger) {
            return (BigInteger)v;
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).toBigInteger();
        }
        if (v instanceof Decimal) {
            return ((Decimal)v).toBigDecimal().toBigInteger();
        }
        if (v instanceof Rational) {
            return ((Rational)v).toBigInteger();
        }
        if (v instanceof Number) {
            return BigInteger.valueOf(((Number)v).longValue());
        }
        if (v instanceof Character) {
            return BigInteger.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return BigInteger.valueOf(0L);
            }
            return new BigInteger(s);
        }
        throw Coercion.coerceError(v, "BigInteger");
    }

    public static Double coerceToDouble(Object v) throws ELException {
        if (v == null) {
            return 0.0;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof Character) {
            return (short)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return 0.0;
            }
            return Double.valueOf(s);
        }
        throw Coercion.coerceError(v, "Double");
    }

    public static Float coerceToFloat(Object v) throws ELException {
        if (v == null) {
            return Float.valueOf(0.0f);
        }
        if (v instanceof Float) {
            return (Float)v;
        }
        if (v instanceof Number) {
            return Float.valueOf(((Number)v).floatValue());
        }
        if (v instanceof Character) {
            return Float.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(s);
        }
        throw Coercion.coerceError(v, "Float");
    }

    public static Long coerceToLong(Object v) throws ELException {
        if (v == null) {
            return 0L;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof Character) {
            return (short)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return 0L;
            }
            return Long.valueOf(s);
        }
        throw Coercion.coerceError(v, "Long");
    }

    public static int coerceToInt(Object v) throws ELException {
        if (v == null) {
            return 0;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof Character) {
            return ((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return 0;
            }
            return Integer.valueOf(s);
        }
        throw Coercion.coerceError(v, "Integer");
    }

    public static Integer coerceToInteger(Object v) throws ELException {
        return Coercion.coerceToInt(v);
    }

    public static Short coerceToShort(Object v) throws ELException {
        if (v == null) {
            return (short)0;
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof Number) {
            return ((Number)v).shortValue();
        }
        if (v instanceof Character) {
            return (short)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return (short)0;
            }
            return Short.valueOf(s);
        }
        throw Coercion.coerceError(v, "Long");
    }

    public static Byte coerceToByte(Object v) throws ELException {
        if (v == null) {
            return (byte)0;
        }
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof Number) {
            return ((Number)v).byteValue();
        }
        if (v instanceof Character) {
            return (byte)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return (byte)0;
            }
            return Byte.valueOf(s);
        }
        throw Coercion.coerceError(v, "Byte");
    }

    public static Character coerceToCharacter(Object v) throws ELException {
        if (v == null) {
            return Character.valueOf('\u0000');
        }
        if (v instanceof Character) {
            return (Character)v;
        }
        if (v instanceof Number) {
            return Character.valueOf((char)((Number)v).shortValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(s.charAt(0));
        }
        throw Coercion.coerceError(v, "Character");
    }

    public static Boolean coerceToBoolean(Object v) throws ELException {
        if (v == null) {
            return Boolean.FALSE;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.valueOf(s);
        }
        throw Coercion.coerceError(v, "Boolean");
    }

    public static <E extends Enum<E>> Enum<E> coerceToEnum(Object v, Class<E> t) {
        if (v == null) {
            return null;
        }
        if (t.isInstance(v)) {
            return (Enum)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return null;
            }
            return Enum.valueOf(t, s);
        }
        throw Coercion.coerceError(v, t.getName());
    }

    public static Seq coerceToSeq(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Seq) {
            return (Seq)v;
        }
        if (v instanceof List) {
            return ListSeq.make((List)v);
        }
        if (v instanceof Iterable) {
            return IteratorSeq.make(((Iterable)v).iterator());
        }
        if (v instanceof Object[]) {
            return ArraySeq.make((Object[])v);
        }
        if (v.getClass().isArray()) {
            return PArraySeq.make(v);
        }
        throw Coercion.coerceError(v, "Seq");
    }

    public static boolean canCoerceToSeq(Object v) {
        return v != null && Coercion.canCoerceToSeq(v.getClass());
    }

    public static boolean canCoerceToSeq(Class<?> t) {
        return t.isArray() || Iterable.class.isAssignableFrom(t);
    }

    public static Object coerceToAny(Object v, Class<?> t) throws ELException {
        Object proxy;
        if (v == null || t.isInstance(v)) {
            return v;
        }
        if (t == Seq.class || t == List.class) {
            return Coercion.coerceToSeq(v);
        }
        if (v instanceof String) {
            String s = (String)v;
            PropertyEditor editor = PropertyEditorManager.findEditor(t);
            if (editor == null) {
                if (s.length() == 0) {
                    return null;
                }
                throw Coercion.coerceError(v, t.getName());
            }
            try {
                editor.setAsText(s);
                return editor.getValue();
            }
            catch (IllegalArgumentException ex) {
                if (s.length() == 0) {
                    return null;
                }
                throw ex;
            }
        }
        if (v instanceof ClosureObject && t.isInstance(proxy = ((ClosureObject)v).get_proxy())) {
            return proxy;
        }
        throw Coercion.coerceError(v, t.getName());
    }

    public static Object coerce(Object v, Class<?> t) throws ELException {
        if (t.isInstance(v)) {
            return v;
        }
        switch (Coercion.typeof(t)) {
            case 17: {
                return Coercion.coerceToString(v);
            }
            case 18: {
                return Coercion.coerceToBigDecimal(v);
            }
            case 19: {
                return Coercion.coerceToBigInteger(v);
            }
            case 22: {
                return Coercion.coerceToDecimal(v);
            }
            case 23: {
                return Coercion.coerceToRational(v);
            }
            case 15: 
            case 16: {
                return Coercion.coerceToDouble(v);
            }
            case 13: 
            case 14: {
                return Coercion.coerceToFloat(v);
            }
            case 11: 
            case 12: {
                return Coercion.coerceToLong(v);
            }
            case 9: 
            case 10: {
                return Coercion.coerceToInteger(v);
            }
            case 7: 
            case 8: {
                return Coercion.coerceToShort(v);
            }
            case 3: 
            case 4: {
                return Coercion.coerceToByte(v);
            }
            case 5: 
            case 6: {
                return Coercion.coerceToCharacter(v);
            }
            case 1: 
            case 2: {
                return Coercion.coerceToBoolean(v);
            }
            case 20: {
                return Coercion.coerceToEnum(v, t);
            }
        }
        return Coercion.coerceToAny(v, t);
    }

    private static ELException coerceError(Object v, String t) {
        return new ELException(Resources._T("JSPRT_COERCE_ERROR", v.getClass().getName(), t));
    }

    private Coercion() {
    }

    static {
        typeMap.put(Boolean.TYPE, 1);
        typeMap.put(Boolean.class, 2);
        typeMap.put(Byte.TYPE, 3);
        typeMap.put(Byte.class, 4);
        typeMap.put(Character.TYPE, 5);
        typeMap.put(Character.class, 6);
        typeMap.put(Short.TYPE, 7);
        typeMap.put(Short.class, 8);
        typeMap.put(Integer.TYPE, 9);
        typeMap.put(Integer.class, 10);
        typeMap.put(Long.TYPE, 11);
        typeMap.put(Long.class, 12);
        typeMap.put(Float.TYPE, 13);
        typeMap.put(Float.class, 14);
        typeMap.put(Double.TYPE, 15);
        typeMap.put(Double.class, 16);
        typeMap.put(BigDecimal.class, 18);
        typeMap.put(BigInteger.class, 19);
        typeMap.put(String.class, 17);
        typeMap.put(Object.class, 21);
        typeMap.put(Decimal.class, 22);
        typeMap.put(Rational.class, 23);
    }
}

