/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.VariableMapper;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExpressionImpl
extends MethodExpression {
    private String expression;
    private ELNode node;
    private Class<?> expectedType;
    private Class<?>[] paramTypes;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;

    public MethodExpressionImpl(String expression, ELNode node, Class<?> expectedType, Class<?>[] paramTypes, FunctionMapper fnMapper, VariableMapper varMapper) {
        this.expression = expression;
        this.node = node;
        this.expectedType = expectedType;
        this.paramTypes = paramTypes;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
    }

    public MethodInfo getMethodInfo(ELContext elctx) {
        try {
            StackTrace.addFrame(elctx, "__expression__", null, 0);
            EvaluationContext ctx = new EvaluationContext(elctx, this.fnMapper, this.varMapper);
            MethodInfo info = this.node.getMethodInfo(ctx);
            MethodInfo methodInfo = new MethodInfo(info.getName(), info.getReturnType(), (Class[])this.paramTypes);
            return methodInfo;
        }
        catch (EvaluationException ex) {
            throw this.wrap(elctx, ex);
        }
        catch (RuntimeException ex) {
            throw this.wrap(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    public Object invoke(ELContext elctx, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        try {
            StackTrace.addFrame(elctx, "__expression__", null, 0);
            EvaluationContext ctx = new EvaluationContext(elctx, this.fnMapper, this.varMapper);
            Object result = this.node.invokeMethod(ctx, args);
            if (result == null || this.expectedType == Void.TYPE) {
                Object var5_7 = null;
                return var5_7;
            }
            if (this.expectedType == null || this.expectedType == Object.class) {
                Object object = result;
                return object;
            }
            Object object = TypeCoercion.coerce(elctx, result, this.expectedType);
            return object;
        }
        catch (EvaluationException ex) {
            throw this.wrap(elctx, ex);
        }
        catch (RuntimeException ex) {
            throw this.wrap(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    private EvaluationException wrap(ELContext elctx, EvaluationException ex) {
        String message = ex.getRawMessage() + "\n>>> " + this.expression;
        EvaluationException ex2 = new EvaluationException(elctx, message);
        ex2.initCause(ex.getCause());
        ex2.setStackTrace(ex.getStackTrace());
        return ex2;
    }

    private EvaluationException wrap(ELContext elctx, RuntimeException ex) {
        String message = ex.getMessage() + "\n>>>" + this.expression;
        return new EvaluationException(elctx, message, ex);
    }

    public String getExpressionString() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodExpressionImpl) {
            return this.expression.equals(((MethodExpressionImpl)((Object)obj)).getExpressionString());
        }
        return false;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public String toString() {
        return this.expression;
    }

    public boolean isLiteralText() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.expression);
        out.writeUTF(this.expectedType == null ? "" : this.expectedType.getName());
        if (this.paramTypes == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.paramTypes.length);
            for (Class<?> type : this.paramTypes) {
                out.writeUTF(type.getName());
            }
        }
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.expression = in.readUTF();
        this.node = Parser.parse(this.expression);
        String type = in.readUTF();
        this.expectedType = type.length() == 0 ? null : Utils.findClass(type);
        int len = in.readInt();
        if (len >= 0) {
            this.paramTypes = new Class[len];
            for (int i = 0; i < len; ++i) {
                type = in.readUTF();
                this.paramTypes[i] = Utils.findClass(type);
            }
        }
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }
}

