/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueExpressionImpl
extends ValueExpression
implements Serializable {
    private static final long serialVersionUID = -9053167105172092880L;
    private String expression;
    private ELNode node;
    private Class<?> expectedType;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;

    public ValueExpressionImpl(String expression, ELNode node, Class<?> expectedType, FunctionMapper fnMapper, VariableMapper varMapper) {
        this.expression = expression;
        this.node = node;
        this.expectedType = expectedType;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
    }

    public Object getValue(ELContext elctx) {
        try {
            StackTrace.addFrame(elctx, "__expression__", null, 0);
            EvaluationContext ctx = new EvaluationContext(elctx, this.fnMapper, this.varMapper);
            Object value = this.node.getValue(ctx);
            if (this.expectedType == null || this.expectedType == Object.class) {
                Object object = value;
                return object;
            }
            Object object = TypeCoercion.coerce(elctx, value, this.expectedType);
            return object;
        }
        catch (EvaluationException ex) {
            throw this.wrap(elctx, ex);
        }
        catch (RuntimeException ex) {
            throw this.wrap(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    public void setValue(ELContext elctx, Object value) {
        try {
            StackTrace.addFrame(elctx, "__expression__", null, 0);
            EvaluationContext ctx = new EvaluationContext(elctx, this.fnMapper, this.varMapper);
            this.node.setValue(ctx, value);
        }
        catch (EvaluationException ex) {
            throw this.wrap(elctx, ex);
        }
        catch (RuntimeException ex) {
            throw this.wrap(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    public boolean isReadOnly(ELContext elctx) {
        try {
            StackTrace.addFrame(elctx, "__expression__", null, 0);
            EvaluationContext ctx = new EvaluationContext(elctx, this.fnMapper, this.varMapper);
            boolean bl = this.node.isReadOnly(ctx);
            return bl;
        }
        catch (EvaluationException ex) {
            throw this.wrap(elctx, ex);
        }
        catch (RuntimeException ex) {
            throw this.wrap(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    public Class<?> getType(ELContext elctx) {
        try {
            StackTrace.addFrame(elctx, "__expression__", null, 0);
            EvaluationContext ctx = new EvaluationContext(elctx, this.fnMapper, this.varMapper);
            Class clazz = this.node.getType(ctx);
            return clazz;
        }
        catch (EvaluationException ex) {
            throw this.wrap(elctx, ex);
        }
        catch (RuntimeException ex) {
            throw this.wrap(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    private EvaluationException wrap(ELContext elctx, EvaluationException ex) {
        String message = ex.getRawMessage() + "\n>>> " + this.expression;
        EvaluationException ex2 = new EvaluationException(elctx, message);
        ex2.initCause(ex.getCause());
        ex2.setStackTrace(ex.getStackTrace());
        return ex2;
    }

    private EvaluationException wrap(ELContext elctx, RuntimeException ex) {
        String message = ex.getMessage() + "\n>>>" + this.expression;
        return new EvaluationException(elctx, message, ex);
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueExpressionImpl) {
            return this.expression.equals(((ValueExpressionImpl)obj).getExpressionString());
        }
        return false;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean isLiteralText() {
        return this.node instanceof ELNode.LITERAL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.expression);
        out.writeUTF(this.expectedType == null ? "" : this.expectedType.getName());
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.expression = in.readUTF();
        this.node = Parser.parse(this.expression);
        String type = in.readUTF();
        this.expectedType = type.length() == 0 ? null : Utils.findClass(type);
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }
}

