/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.DelegatingELContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.PropertyResolvable;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.DelegatingClosure;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.ThisObject;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicThisObject
extends ThisObject {
    protected ClassDefinition cdef;
    protected Map<String, Closure> vmap;
    protected List<Class> interfaces;
    protected ClosureObject owner;
    protected Object proxy;
    private static final long serialVersionUID = 5012955516372665795L;

    BasicThisObject(ELContext elctx, ClassDefinition cdef, Map<String, Closure> vmap) {
        this.cdef = cdef;
        this.vmap = vmap;
        for (Map.Entry<String, Closure> e : vmap.entrySet()) {
            e.setValue(this.attach(elctx, e.getValue()));
        }
    }

    @Override
    protected void addInterface(Class iface) {
        assert (iface.isInterface());
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<Class>();
            this.interfaces.add(ClosureObject.class);
        }
        if (!this.interfaces.contains(iface)) {
            this.interfaces.add(iface);
        }
    }

    @Override
    protected Class[] getInterfaces() {
        if (this.interfaces == null) {
            return null;
        }
        Class[] ifs = this.interfaces.toArray(new Class[this.interfaces.size()]);
        this.interfaces = null;
        return ifs;
    }

    @Override
    protected void setOwner(ClosureObject owner) {
        this.owner = owner;
    }

    @Override
    protected void init(ELContext elctx, Closure[] args) {
        Closure init = this.get_closure(elctx, "__init__");
        if (init != null) {
            init.invoke(elctx, args);
        } else if (args.length != 0) {
            throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", this.cdef.getName(), 0, args.length));
        }
    }

    @Override
    protected Object createProxy(ELContext elctx) {
        assert (this.owner != null && this.proxy == null);
        if (this.interfaces == null) {
            this.proxy = this.owner;
        } else {
            ClosureProxyHandler handler = new ClosureProxyHandler(elctx, this.owner);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            this.proxy = Proxy.newProxyInstance(loader, this.getInterfaces(), (InvocationHandler)handler);
        }
        return this.proxy;
    }

    @Override
    public ClassDefinition get_class() {
        return this.cdef;
    }

    @Override
    public ClosureObject get_owner() {
        return this.owner;
    }

    @Override
    public Object get_proxy() {
        return this.proxy;
    }

    @Override
    public Closure get_closure(ELContext elctx, String name) {
        return this.get_my_closure(elctx, name);
    }

    @Override
    public Map<String, Closure> get_closures(ELContext elctx) {
        HashMap<String, Closure> map = new HashMap<String, Closure>();
        for (Map.Entry<String, Closure> e : this.vmap.entrySet()) {
            if (!e.getValue().isPublic()) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    @Override
    protected Closure get_my_closure(ELContext elctx, String name) {
        Closure c = this.vmap.get(name);
        if (c == null && (c = this.cdef.getExpandoClosure(name)) != null) {
            c = new ExpandoClosure(c, this.get_owner());
            this.vmap.put(name, c);
        }
        return c;
    }

    @Override
    protected Map<String, Closure> getClosureMap() {
        return this.vmap;
    }

    protected Closure attach(ELContext elctx, Closure closure) {
        closure._setenv(elctx, new Environment(elctx, this));
        if (closure.isProcedure() && closure.isSynchronized()) {
            closure = new SynchronizedClosure(this, closure);
        }
        return closure;
    }

    protected ValueExpression resolveVariable(ELContext elctx, String name) {
        if ("this".equals(name)) {
            return this;
        }
        if ("self".equals(name)) {
            Object proxy = this.get_proxy();
            if (proxy instanceof Closure) {
                return (Closure)((Object)proxy);
            }
            return new LiteralClosure(proxy, true);
        }
        return this.get_closure(elctx, name);
    }

    static class ClosureProxyHandler
    implements InvocationHandler,
    Serializable {
        private transient ELContext elctx;
        private ClosureObject target;
        private static final long serialVersionUID = -5877362109550947177L;

        ClosureProxyHandler(ELContext elctx, ClosureObject target) {
            this.elctx = elctx;
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null) {
                args = ELUtils.NO_ARGS;
            }
            if (PropertyResolvable.class.isAssignableFrom(method.getDeclaringClass())) {
                try {
                    Object result = method.invoke((Object)this.target, args);
                    if (result == this.target) {
                        result = proxy;
                    }
                    return result;
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            ELContext elctx = DelegatingELContext.get(this.elctx);
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Object result = this.target.invoke(elctx, name, ELEngine.getCallArgs(args));
            if (result != ELUtils.NO_RESULT) {
                if (type == Void.TYPE) {
                    return null;
                }
                if (result == this.target) {
                    return proxy;
                }
                return TypeCoercion.coerce(elctx, result, type);
            }
            if (name.startsWith("get") && args.length == 0) {
                name = ELUtils.decapitalize(name.substring(3));
                elctx.setPropertyResolved(false);
                Object value = this.target.getValue(elctx, name);
                if (elctx.isPropertyResolved()) {
                    return TypeCoercion.coerce(elctx, value, type);
                }
            } else if (name.startsWith("is") && args.length == 0 && type == Boolean.TYPE) {
                name = ELUtils.decapitalize(name.substring(2));
                elctx.setPropertyResolved(false);
                Object value = this.target.getValue(elctx, name);
                if (elctx.isPropertyResolved()) {
                    return TypeCoercion.coerce(elctx, value, type);
                }
            } else if (name.startsWith("set") && args.length == 1) {
                name = ELUtils.decapitalize(name.substring(3));
                elctx.setPropertyResolved(false);
                this.target.setValue(elctx, name, args[0]);
                if (elctx.isPropertyResolved()) {
                    return null;
                }
            }
            if (method.getDeclaringClass() == Object.class) {
                return this.invokeObjectMethod(method, args);
            }
            throw new MethodNotFoundException(Resources._T("EL_METHOD_NOT_FOUND", this.target.get_class().getName(), name));
        }

        private Object invokeObjectMethod(Method method, Object[] args) {
            String name = method.getName();
            if (name.equals("equals")) {
                return this.target.equals(args[0]);
            }
            if (name.equals("hashCode")) {
                return this.target.hashCode();
            }
            if (name.equals("toString")) {
                return this.target.toString();
            }
            throw new MethodNotFoundException(Resources._T("EL_METHOD_NOT_FOUND", this.target.get_class().getName(), name));
        }
    }

    static class SynchronizedClosure
    extends DelegatingClosure {
        final BasicThisObject thisObj;

        SynchronizedClosure(BasicThisObject thisObj, Closure delegate) {
            super(delegate);
            this.thisObj = thisObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(ELContext elctx, Closure[] args) {
            Object proxy = this.thisObj.get_proxy();
            if (proxy != null) {
                Object object = proxy;
                synchronized (object) {
                    return this.delegate.invoke(elctx, args);
                }
            }
            return this.delegate.invoke(elctx, args);
        }
    }

    static class ExpandoClosure
    extends DelegatingClosure {
        final Closure scope;

        ExpandoClosure(Closure delegate, ClosureObject scope) {
            super(delegate);
            this.scope = scope instanceof Closure ? (Closure)((Object)scope) : new LiteralClosure(scope);
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            Closure[] expando = new Closure[args.length + 1];
            expando[0] = this.scope;
            System.arraycopy(args, 0, expando, 1, args.length);
            return this.delegate.invoke(elctx, expando);
        }

        public Object getValue(ELContext elctx) {
            return this;
        }
    }

    static class Environment
    extends VariableMapper {
        protected ELContext elctx;
        protected BasicThisObject thisObj;

        Environment(ELContext elctx, BasicThisObject thisObject) {
            this.elctx = elctx;
            this.thisObj = thisObject;
        }

        public ValueExpression resolveVariable(String name) {
            ValueExpression value = this.thisObj.resolveVariable(this.elctx, name);
            if (value != null) {
                return value;
            }
            value = this.thisObj.cdef.getPrivateClosure(this.elctx, name);
            if (value != null) {
                return value;
            }
            return null;
        }

        public ValueExpression setVariable(String name, ValueExpression var) {
            return null;
        }
    }
}

