/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.closure.BasicThisObject;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.DefaultClosureObject;
import org.operamasks.el.eval.closure.ThisObject;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DerivedThisObject
extends BasicThisObject {
    protected SuperObject zuper;

    DerivedThisObject(ELContext elctx, ClassDefinition cdef, Map<String, Closure> vmap, ThisObject base) {
        super(elctx, cdef, vmap);
        this.zuper = new SuperObject(this, base);
        this.override(base);
    }

    @Override
    protected void addInterface(Class iface) {
        this.zuper.base.addInterface(iface);
    }

    @Override
    protected void setOwner(ClosureObject owner) {
        super.setOwner(owner);
        this.zuper.base.setOwner(owner);
    }

    @Override
    protected Object createProxy(ELContext elctx) {
        if (!this.zuper.initialized) {
            this.zuper.invoke(elctx, ELUtils.NO_PARAMS);
        }
        this.proxy = this.zuper.base.createProxy(elctx);
        return this.proxy;
    }

    @Override
    public Closure get_closure(ELContext elctx, String name) {
        Closure c = super.get_closure(elctx, name);
        if (c == null) {
            c = this.zuper.get_closure(elctx, name);
        }
        return c;
    }

    @Override
    public Map<String, Closure> get_closures(ELContext elctx) {
        Map<String, Closure> map = super.get_closures(elctx);
        Map<String, Closure> smap = this.zuper.base.get_closures(elctx);
        for (Map.Entry<String, Closure> e : smap.entrySet()) {
            if (map.containsKey(e.getKey()) || !e.getValue().isPublic()) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    @Override
    public Object invoke(ELContext elctx, String name, Closure[] args) {
        Object result = super.invoke(elctx, name, args);
        if (result == ELUtils.NO_RESULT) {
            result = this.zuper.invoke(elctx, name, args);
        }
        return result;
    }

    @Override
    protected Object invokePublic(ELContext elctx, String name, Closure[] args) {
        Object result = super.invokePublic(elctx, name, args);
        if (result == ELUtils.NO_RESULT) {
            result = this.zuper.invokePublic(elctx, name, args);
        }
        return result;
    }

    @Override
    protected Object invokeProtected(ELContext elctx, String name, Closure[] args) {
        Object result = super.invokeProtected(elctx, name, args);
        if (result == ELUtils.NO_RESULT) {
            result = this.zuper.invoke(elctx, name, args);
        }
        return result;
    }

    @Override
    protected ValueExpression resolveVariable(ELContext elctx, String name) {
        if ("super".equals(name)) {
            return this.zuper;
        }
        return super.resolveVariable(elctx, name);
    }

    protected void override(ThisObject base) {
        Map<String, Closure> basemap = base.getClosureMap();
        for (Map.Entry e : this.vmap.entrySet()) {
            Closure bc;
            Closure c;
            String key = (String)e.getKey();
            if (!this.canOverride(key, c = (Closure)((Object)e.getValue()), bc = basemap.get(key))) continue;
            basemap.put(key, c);
            if (bc == null) continue;
            this.zuper.add_closure(key, bc);
        }
        if (base instanceof DerivedThisObject) {
            this.override(((DerivedThisObject)base).zuper.base);
        }
    }

    protected boolean canOverride(String name, Closure c, Closure bc) {
        if (name.equals("__init__")) {
            return false;
        }
        if (bc == null) {
            return false;
        }
        if (c.isPrivate() || bc.isPrivate()) {
            return false;
        }
        return c.isProcedure() && bc.isProcedure();
    }

    static class SuperObject
    extends DefaultClosureObject {
        protected ThisObject base;
        protected Map<String, Closure> smap;
        protected boolean initialized = false;

        SuperObject(ThisObject thisObj, ThisObject base) {
            super(thisObj);
            this.base = base;
            this.smap = new LinkedHashMap<String, Closure>();
        }

        void add_closure(String name, Closure closure) {
            if (!this.smap.containsKey(name)) {
                this.smap.put(name, closure);
            }
        }

        public Closure get_closure(ELContext elctx, String name) {
            if (name.equals("__init__")) {
                return null;
            }
            Closure c = this.smap.get(name);
            if (c == null && ((c = this.base.get_closure(elctx, name)) == null || c.isPrivate() && !this.base.get_class().inScope(elctx))) {
                return null;
            }
            return c;
        }

        public Object invoke(ELContext elctx, String name, Closure[] args) {
            if (name.equals("__init__")) {
                return ELUtils.NO_RESULT;
            }
            Closure c = this.smap.get(name);
            if (c != null) {
                return this.base.get_class().invokeInScope(elctx, c, args);
            }
            return this.base.invokeProtected(elctx, name, args);
        }

        public Object invokePublic(ELContext elctx, String name, Closure[] args) {
            if (name.equals("__init__")) {
                return ELUtils.NO_RESULT;
            }
            return this.base.invokePublic(elctx, name, args);
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            if (this.initialized) {
                throw new EvaluationException(elctx, Resources._T("EL_BASE_CLASS_INITIALIZED"));
            }
            Closure init = this.base.get_closure(elctx, "__init__");
            if (init != null) {
                init.invoke(elctx, args);
            } else if (args.length != 0) {
                throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", this.base.get_class().getName(), 0, args.length));
            }
            this.initialized = true;
            return null;
        }
    }
}

