/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.closure.AnnotatedClosure;
import org.operamasks.el.eval.closure.MetaData;
import org.operamasks.el.eval.closure.ValueChangeListener;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralClosure
extends AnnotatedClosure {
    private Object value;
    private boolean readonly;
    private transient ValueChangeListener listener;

    public LiteralClosure(Object value) {
        this.value = value;
    }

    public LiteralClosure(Object value, boolean readonly) {
        this.value = value;
        this.readonly = readonly;
    }

    @Override
    public void setMetaData(MetaData metadata) {
        super.setMetaData(metadata);
        this.readonly = this.readonly || metadata.isFinal();
    }

    @Override
    public void setValueChangeListener(ValueChangeListener listener) {
        this.listener = listener;
    }

    public Object getValue(ELContext elctx) {
        return this.value;
    }

    public void setValue(ELContext elctx, Object value) {
        if (this.readonly) {
            throw new PropertyNotWritableException();
        }
        if (this.listener != null) {
            Object oldValue = this.value;
            this.value = value;
            this.listener.valueChanged(oldValue, value);
        } else {
            this.value = value;
        }
    }

    public boolean isReadOnly(ELContext elctx) {
        return this.readonly;
    }

    public Class<?> getType(ELContext elctx) {
        return this.value == null ? null : this.value.getClass();
    }

    public Class<?> getExpectedType() {
        return Object.class;
    }

    @Override
    public int arity(ELContext elctx) {
        return this.value instanceof Closure ? ((Closure)((Object)this.value)).arity(elctx) : -1;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext elctx) {
        if (this.value instanceof Closure) {
            return ((Closure)((Object)this.value)).getMethodInfo(elctx);
        }
        throw new EvaluationException(elctx, Resources._T("EL_INVALID_METHOD_EXPRESSION", ""));
    }

    @Override
    public Object invoke(ELContext elctx, Closure[] args) {
        return ELEngine.invokeTarget(elctx, this.value, args);
    }

    public String getExpressionString() {
        return this.value == null ? null : this.value.toString();
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralClosure) {
            LiteralClosure other = (LiteralClosure)((Object)obj);
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }
}

