/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import org.operamasks.el.eval.DelegatingELContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.PropertyResolvable;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.closure.BasicThisObject;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.DefaultClosureObject;
import org.operamasks.el.eval.closure.DelegatingClosure;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.eval.closure.ThisObject;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.resources.Resources;
import org.operamasks.net.sf.cglib.proxy.Enhancer;
import org.operamasks.net.sf.cglib.proxy.MethodInterceptor;
import org.operamasks.net.sf.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxiedThisObject
extends BasicThisObject {
    protected Class superclass;
    protected SuperObject zuper;
    protected boolean creatingProxy;

    ProxiedThisObject(ELContext elctx, ClassDefinition cdef, Map<String, Closure> vmap, Class<?> superclass) {
        super(elctx, cdef, vmap);
        this.superclass = superclass;
        this.zuper = new SuperObject(this);
    }

    @Override
    protected Object createProxy(ELContext elctx) {
        if (this.proxy == null) {
            this.proxy = this.createProxy(elctx, null);
        }
        return this.proxy;
    }

    protected Object createProxy(ELContext elctx, Closure[] args) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(loader);
        enhancer.setSuperclass(this.superclass);
        enhancer.setInterfaces(this.getInterfaces());
        enhancer.setCallback(new ProxyInterceptor(elctx, this.get_owner()));
        this.creatingProxy = true;
        try {
            if (args == null || args.length == 0) {
                Object object = enhancer.create();
                return object;
            }
            Constructor<?> cons = ELEngine.resolveConstructor(elctx, this.superclass, args);
            if (cons == null) {
                throw new EvaluationException(elctx, Resources._T("EL_METHOD_NOT_FOUND", this.superclass.getSimpleName()));
            }
            Class[] types = cons.getParameterTypes();
            Object[] values = new Object[args.length];
            for (int i = 0; i < types.length; ++i) {
                values[i] = TypeCoercion.coerce(elctx, args[i].getValue(elctx), types[i]);
            }
            Object object = enhancer.create(types, values);
            return object;
        }
        catch (EvaluationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EvaluationException(elctx, ex);
        }
        finally {
            this.creatingProxy = false;
        }
    }

    @Override
    protected Class[] getInterfaces() {
        if (this.interfaces == null) {
            return new Class[]{ClosureObject.class};
        }
        return super.getInterfaces();
    }

    @Override
    public Closure get_closure(ELContext elctx, String name) {
        Closure c = super.get_closure(elctx, name);
        if (c == null) {
            c = this.zuper.get_closure(elctx, name);
        }
        return c;
    }

    @Override
    public Map<String, Closure> get_closures(ELContext elctx) {
        Map<String, Closure> map = super.get_closures(elctx);
        Map<String, Closure> smap = this.zuper.get_closures(elctx);
        for (Map.Entry<String, Closure> e : smap.entrySet()) {
            if (map.containsKey(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    @Override
    public Object invoke(ELContext elctx, String name, Closure[] args) {
        Object result = super.invoke(elctx, name, args);
        if (result == ELUtils.NO_RESULT) {
            result = this.zuper.invoke(elctx, name, args);
        }
        return result;
    }

    @Override
    protected Object invokePublic(ELContext elctx, String name, Closure[] args) {
        Object result = super.invokePublic(elctx, name, args);
        if (result == ELUtils.NO_RESULT) {
            result = this.zuper.invokePublic(elctx, name, args);
        }
        return result;
    }

    @Override
    protected Object invokeProtected(ELContext elctx, String name, Closure[] args) {
        Object result = super.invokeProtected(elctx, name, args);
        if (result == ELUtils.NO_RESULT) {
            result = this.zuper.invoke(elctx, name, args);
        }
        return result;
    }

    @Override
    protected ValueExpression resolveVariable(ELContext elctx, String name) {
        if ("super".equals(name)) {
            return this.zuper;
        }
        return super.resolveVariable(elctx, name);
    }

    static class ProxyInterceptor
    implements MethodInterceptor {
        private ELContext elctx;
        private ClosureObject target;

        public ProxyInterceptor(ELContext elctx, ClosureObject target) {
            this.elctx = elctx;
            this.target = target;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if (args == null) {
                args = ELUtils.NO_ARGS;
            }
            if (PropertyResolvable.class.isAssignableFrom(method.getDeclaringClass())) {
                try {
                    Object result = method.invoke((Object)this.target, args);
                    if (result == this.target) {
                        result = proxy;
                    }
                    return result;
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            ELContext elctx = DelegatingELContext.get(this.elctx);
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Object result = this.target.get_this().invoke(elctx, name, ELEngine.getCallArgs(args));
            if (result != ELUtils.NO_RESULT) {
                if (type == Void.TYPE) {
                    return null;
                }
                if (result == this.target) {
                    return proxy;
                }
                return TypeCoercion.coerce(elctx, result, type);
            }
            if (name.startsWith("get") && args.length == 0) {
                name = ELUtils.decapitalize(name.substring(3));
                elctx.setPropertyResolved(false);
                Object value = this.target.getValue(elctx, name);
                if (elctx.isPropertyResolved()) {
                    return TypeCoercion.coerce(elctx, value, type);
                }
            } else if (name.startsWith("is") && args.length == 0 && type == Boolean.TYPE) {
                name = ELUtils.decapitalize(name.substring(2));
                elctx.setPropertyResolved(false);
                Object value = this.target.getValue(elctx, name);
                if (elctx.isPropertyResolved()) {
                    return TypeCoercion.coerce(elctx, value, type);
                }
            } else if (name.startsWith("set") && args.length == 1) {
                name = ELUtils.decapitalize(name.substring(3));
                elctx.setPropertyResolved(false);
                this.target.setValue(elctx, name, args[0]);
                if (elctx.isPropertyResolved()) {
                    return null;
                }
            }
            return methodProxy.invokeSuper(proxy, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SuperObject
    extends DefaultClosureObject {
        SuperObject(ThisObject thisObj) {
            super(thisObj);
        }

        @Override
        public Closure get_closure(ELContext elctx, String name) {
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            MethodClosure method = resolver.resolveProtectedMethod(ProxiedThisObject.this.superclass, name);
            if (method != null) {
                return this.wrap(name, method);
            }
            return null;
        }

        @Override
        public Map<String, Closure> get_closures(ELContext elctx) {
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            HashMap<String, Closure> map = new HashMap<String, Closure>();
            for (Method method : ProxiedThisObject.this.superclass.getMethods()) {
                MethodClosure closure;
                String name = method.getName();
                if (map.containsKey(name) || (closure = resolver.resolveMethod(ProxiedThisObject.this.superclass, name)) == null) continue;
                map.put(name, this.wrap(name, closure));
            }
            return map;
        }

        private Closure wrap(final String name, MethodClosure method) {
            return new DelegatingClosure(method){

                public Object invoke(ELContext elctx, Closure[] args) {
                    return SuperObject.this.invoke(elctx, name, args);
                }

                public Object getValue(ELContext elctx) {
                    return this;
                }
            };
        }

        @Override
        public Object invoke(ELContext elctx, Closure[] args) {
            if (ProxiedThisObject.this.proxy != null) {
                throw new EvaluationException(elctx, Resources._T("EL_BASE_CLASS_INITIALIZED"));
            }
            ProxiedThisObject.this.proxy = ProxiedThisObject.this.createProxy(elctx, args);
            return null;
        }

        @Override
        public Object invoke(ELContext elctx, String name, Closure[] args) {
            MethodClosure method;
            if (ProxiedThisObject.this.proxy == null) {
                if (ProxiedThisObject.this.creatingProxy) {
                    return ELUtils.NO_RESULT;
                }
                ProxiedThisObject.this.proxy = ProxiedThisObject.this.createProxy(elctx, null);
            }
            if ((method = MethodResolver.getInstance(elctx).resolveProtectedMethod(ProxiedThisObject.this.superclass, name)) != null) {
                try {
                    return method.invokeSuper(elctx, ProxiedThisObject.this.proxy, args);
                }
                catch (EvaluationException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    throw new EvaluationException(elctx, ex);
                }
            }
            return ELUtils.NO_RESULT;
        }

        public Object invokePublic(ELContext elctx, String name, Closure[] args) {
            MethodClosure method;
            if (ProxiedThisObject.this.proxy == null) {
                if (ProxiedThisObject.this.creatingProxy) {
                    return ELUtils.NO_RESULT;
                }
                ProxiedThisObject.this.proxy = ProxiedThisObject.this.createProxy(elctx, null);
            }
            if ((method = MethodResolver.getInstance(elctx).resolveMethod(ProxiedThisObject.this.superclass, name)) != null) {
                return method.invoke(elctx, ProxiedThisObject.this.proxy, args);
            }
            return ELUtils.NO_RESULT;
        }
    }
}

