/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.seq;

import elite.lang.Closure;
import elite.lang.Seq;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.operamasks.el.eval.seq.Cons;
import org.operamasks.el.eval.seq.FilteredSeq;
import org.operamasks.el.eval.seq.MappedSeq;
import org.operamasks.el.eval.seq.MappendSeq;

public abstract class AbstractSeq
extends AbstractList
implements Seq,
Serializable {
    public boolean isEmpty() {
        return false;
    }

    public int size() {
        return this.isEmpty() ? 0 : 1 + this.tail().size();
    }

    public Object set(Object x) {
        throw new UnsupportedOperationException();
    }

    public Object remove() {
        throw new UnsupportedOperationException();
    }

    public void set_tail(Seq t) {
        throw new UnsupportedOperationException();
    }

    public Seq last() {
        if (this.isEmpty()) {
            return this;
        }
        Seq l = this;
        Seq t;
        while (!(t = l.tail()).isEmpty()) {
            l = t;
        }
        return l;
    }

    static Seq adjoin(Seq xs, Seq ys) {
        if (xs.isEmpty()) {
            return ys;
        }
        if (ys.isEmpty()) {
            return xs;
        }
        Seq result = ys;
        xs = xs.reverse();
        while (!xs.isEmpty()) {
            Cons h = (Cons)xs;
            xs = h.tail;
            h.tail = result;
            result = h;
        }
        return result;
    }

    public Seq reverse() {
        Cons rev = new Cons();
        Seq l = this;
        while (!l.isEmpty()) {
            rev = new Cons(l.get(), rev);
            l = l.tail();
        }
        return rev;
    }

    public Seq append(Seq xs) {
        return AbstractSeq.adjoin(this, xs);
    }

    public Seq map(Closure proc) {
        return MappedSeq.make(this, proc);
    }

    public Seq filter(Closure pred) {
        return FilteredSeq.make(this, pred);
    }

    public Seq mappend(Closure proc) {
        return MappendSeq.make(this, proc);
    }

    public Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        Seq t = this;
        int i = index;
        while (t != null && !t.isEmpty()) {
            if (t != this && t instanceof RandomAccess) {
                return t.get(i);
            }
            if (i == 0) {
                return t.get();
            }
            t = t.tail();
            --i;
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    public Object set(int index, Object x) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        Seq t = this;
        int i = index;
        while (t != null && !t.isEmpty()) {
            if (t != this && t instanceof RandomAccess) {
                return t.set(i, x);
            }
            if (i == 0) {
                return t.set(x);
            }
            t = t.tail();
            --i;
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    public Object remove(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        Seq t = this;
        int i = index;
        while (t != null && !t.isEmpty()) {
            if (t != this && t instanceof RandomAccess) {
                return t.remove(i);
            }
            if (i == 0) {
                return t.remove();
            }
            t = t.tail();
            --i;
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    public Iterator iterator() {
        if (this instanceof RandomAccess) {
            return super.iterator();
        }
        return new Itr(this);
    }

    private static class Itr
    implements Iterator {
        protected Seq next;
        protected Seq lastRet;

        public Itr(Seq seq) {
            this.next = seq;
        }

        public boolean hasNext() {
            return !this.next.isEmpty();
        }

        public Object next() {
            if (this.next.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            this.next = this.next.tail();
            return this.lastRet.get();
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new NoSuchElementException();
            }
            this.lastRet.remove();
            this.next = this.lastRet;
            this.lastRet = null;
        }
    }
}

