/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import java.util.HashMap;
import java.util.Map;
import org.operamasks.el.parser.Operator;
import org.operamasks.el.parser.State;
import org.operamasks.el.parser.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OperatorManager
implements Cloneable {
    State start = new State();
    Map<String, Operator> operators;
    private static OperatorManager shared = new OperatorManager(new State(), new HashMap<String, Operator>());

    private OperatorManager(State start, Map<String, Operator> operators) {
        this.start = start;
        this.operators = operators;
    }

    public static OperatorManager newInstance() {
        return new OperatorManager(OperatorManager.shared.start, OperatorManager.shared.operators);
    }

    public void dirtyCopy() {
        if (this.start == OperatorManager.shared.start) {
            this.start = this.start.copy();
        }
        if (this.operators == OperatorManager.shared.operators) {
            this.operators = new HashMap<String, Operator>(this.operators);
        }
    }

    public void importFrom(OperatorManager other) {
        if (other.operators == this.operators) {
            return;
        }
        for (Operator op : other.operators.values()) {
            Operator myop = this.operators.get(op.name);
            if (myop == op) continue;
            this.dirtyCopy();
            this.addOperator(op.name, op.token, op.token2);
        }
    }

    public OperatorManager clone() {
        try {
            return (OperatorManager)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public void addOperator(String name, int token, int token2) {
        Operator op = new Operator();
        op.name = name;
        op.token = token;
        op.token2 = token2;
        this.operators.put(name, op);
        if (!OperatorManager.isIdentifier(name)) {
            this.addTransition(name.toCharArray(), op);
        }
    }

    public void removeOperator(String name) {
        if (this.operators.remove(name) != null && !OperatorManager.isIdentifier(name)) {
            this.removeTransition(name.toCharArray());
        }
    }

    public Operator getOperator(String name) {
        return this.operators.get(name);
    }

    private void addTransition(char[] cs, Operator accept) {
        State p = this.start;
        for (char c : cs) {
            Transition t = p.get(c);
            if (t == null) {
                t = p.add(c);
            }
            p = t.next;
        }
        p.accept = accept;
    }

    private void removeTransition(char[] cs) {
        this.doRemove(this.start, cs, 0, cs.length);
    }

    private void doRemove(State p, char[] cs, int off, int len) {
        if (off == len) {
            p.accept = null;
            return;
        }
        Transition t = p.get(cs[off]);
        if (t != null) {
            this.doRemove(t.next, cs, off + 1, len);
            if (t.next.isEmpty()) {
                p.remove(t);
            }
        }
    }

    public State dispatch(State current, int event) {
        Transition t = current.get(event);
        return t != null ? t.next : null;
    }

    private static boolean isIdentifier(String id) {
        char c = id.charAt(0);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$';
    }

    static {
        shared.addOperator("{", 81, -1);
        shared.addOperator("}", 82, -1);
        shared.addOperator("(", 77, -1);
        shared.addOperator(")", 78, -1);
        shared.addOperator("[", 79, -1);
        shared.addOperator("]", 80, -1);
        shared.addOperator("?", 76, -1);
        shared.addOperator("??", 6, -1);
        shared.addOperator("??=", 1, 6);
        shared.addOperator(":", 74, -1);
        shared.addOperator("::", 75, -1);
        shared.addOperator("@", 83, -1);
        shared.addOperator(".", 42, -1);
        shared.addOperator("..", 58, -1);
        shared.addOperator("...", 86, -1);
        shared.addOperator(",", 87, -1);
        shared.addOperator(";", 88, -1);
        shared.addOperator("-", 25, -1);
        shared.addOperator("-=", 1, 25);
        shared.addOperator("--", 38, -1);
        shared.addOperator("->", 40, -1);
        shared.addOperator("+", 24, -1);
        shared.addOperator("+=", 1, 24);
        shared.addOperator("++", 37, -1);
        shared.addOperator("<", 17, -1);
        shared.addOperator("<=", 19, -1);
        shared.addOperator("<-", 32, -1);
        shared.addOperator("<<", 21, -1);
        shared.addOperator("<<=", 1, 21);
        shared.addOperator(">", 18, -1);
        shared.addOperator(">=", 20, -1);
        shared.addOperator(">>", 22, -1);
        shared.addOperator(">>>", 23, -1);
        shared.addOperator(">>=", 1, 22);
        shared.addOperator(">>>=", 1, 23);
        shared.addOperator("=", 0, -1);
        shared.addOperator("==", 13, -1);
        shared.addOperator("===", 15, -1);
        shared.addOperator("=>", 85, -1);
        shared.addOperator("!", 33, -1);
        shared.addOperator("!=", 14, -1);
        shared.addOperator("!==", 16, -1);
        shared.addOperator("!?", 7, -1);
        shared.addOperator("~", 34, -1);
        shared.addOperator("|", 10, -1);
        shared.addOperator("|=", 1, 10);
        shared.addOperator("||", 8, -1);
        shared.addOperator("&", 12, -1);
        shared.addOperator("&=", 1, 12);
        shared.addOperator("&&", 9, -1);
        shared.addOperator("^", 30, -1);
        shared.addOperator("^=", 1, 30);
        shared.addOperator("/", 27, -1);
        shared.addOperator("/=", 1, 27);
        shared.addOperator("%", 29, -1);
        shared.addOperator("%=", 1, 29);
        shared.addOperator("*", 26, -1);
        shared.addOperator("*=", 1, 26);
        shared.addOperator("\u00d7", 26, -1);
        shared.addOperator("\u00f7", 27, -1);
        shared.addOperator("\u2260", 14, -1);
        shared.addOperator("\u2264", 19, -1);
        shared.addOperator("\u2265", 20, -1);
        shared.addOperator("\u2208", 32, -1);
        shared.addOperator("\u2192", 40, -1);
        shared.addOperator("\u21d2", 85, -1);
        shared.addOperator("\u00ac", 33, -1);
        shared.addOperator("\u2227", 9, -1);
        shared.addOperator("\u2228", 8, -1);
        shared.addOperator("\u2295", 11, -1);
        shared.addOperator("\u22bb", 11, -1);
        shared.addOperator("module", 91, -1);
        shared.addOperator("and", 9, -1);
        shared.addOperator("or", 8, -1);
        shared.addOperator("eq", 13, -1);
        shared.addOperator("ne", 14, -1);
        shared.addOperator("lt", 17, -1);
        shared.addOperator("gt", 18, -1);
        shared.addOperator("le", 19, -1);
        shared.addOperator("ge", 20, -1);
        shared.addOperator("div", 28, -1);
        shared.addOperator("mod", 29, -1);
        shared.addOperator("xor", 11, -1);
        shared.addOperator("shl", 21, -1);
        shared.addOperator("shr", 22, -1);
        shared.addOperator("ushr", 23, -1);
        shared.addOperator("is", 31, -1);
        shared.addOperator("in", 32, -1);
    }
}

