/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import java.util.ArrayList;
import java.util.List;
import org.operamasks.el.parser.Operator;
import org.operamasks.el.parser.Transition;

class State {
    List<Transition> transitions = new ArrayList<Transition>();
    Operator accept;
    private Transition[] table;
    private static final int MAX_EVENT = 256;
    private static final int SHRESHOLD = 10;

    State() {
    }

    Transition get(int event) {
        Transition t;
        if (event < 256 && this.table != null && (t = this.table[event]) != null) {
            return t;
        }
        for (Transition t2 : this.transitions) {
            if (event != t2.event) continue;
            return t2;
        }
        return null;
    }

    Transition add(int event) {
        Transition t = new Transition();
        t.event = event;
        t.next = new State();
        this.transitions.add(t);
        if (event < 256) {
            if (this.table != null) {
                this.table[event] = t;
            } else if (this.transitions.size() > 10) {
                this.table = new Transition[256];
                for (Transition x : this.transitions) {
                    if (x.event >= 256) continue;
                    this.table[x.event] = x;
                }
            }
        }
        return t;
    }

    void remove(Transition t) {
        this.transitions.remove(t);
        if (t.event < 256 && this.table != null) {
            this.table[t.event] = null;
        }
    }

    boolean isEmpty() {
        return this.transitions.isEmpty() && this.accept == null;
    }

    State copy() {
        State copy = new State();
        for (Transition t : this.transitions) {
            copy.transitions.add(t.copy());
        }
        copy.accept = this.accept;
        if (this.table != null) {
            copy.table = new Transition[256];
            for (Transition t : copy.transitions) {
                if (t.event >= 256) continue;
                copy.table[t.event] = t;
            }
        }
        return copy;
    }
}

