/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResolver {
    private ClassLoader loader;
    private List<String> packages = new ArrayList<String>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, Class<?>> cache = new HashMap();

    public static ClassResolver getInstance(ELContext context) {
        ClassResolver cr = (ClassResolver)context.getContext(ClassResolver.class);
        if (cr == null) {
            cr = new ClassResolver();
            context.putContext(ClassResolver.class, (Object)cr);
        }
        return cr;
    }

    public ClassResolver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassResolver(ClassLoader loader) {
        this.loader = loader;
        this.addImport("elite.lang.*");
        this.addImport("java.lang.*");
        this.addImport("java.util.*");
        this.addImport("java.lang.reflect.Array");
        this.addImport("java.math.BigInteger");
        this.addImport("java.math.BigDecimal");
    }

    public void addImport(String name) {
        if (name.endsWith(".*")) {
            String pkg = name.substring(0, name.length() - 2);
            if (!this.packages.contains(pkg)) {
                this.packages.add(pkg);
            }
        } else {
            String simpleName = name.substring(name.lastIndexOf(46) + 1);
            this.aliases.put(simpleName, name);
        }
    }

    public Class<?> resolveClass(String name) throws ClassNotFoundException {
        Class<?> c = this.cache.get(name);
        if (c != null) {
            return c;
        }
        if (name.indexOf(46) == -1) {
            String qname = this.aliases.get(name);
            if (qname != null) {
                c = this.resolveClass0(qname);
                if (c != null) {
                    this.cache.put(name, c);
                    return c;
                }
                throw new ClassNotFoundException(qname);
            }
            for (String pkg : this.packages) {
                qname = pkg + "." + name;
                c = this.resolveClass0(qname);
                if (c == null) continue;
                this.cache.put(name, c);
                return c;
            }
        }
        if ((c = this.resolveClass0(name)) != null) {
            this.cache.put(name, c);
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class<?> resolveClass0(String name) {
        try {
            return Utils.findClass(name, this.loader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (NoClassDefFoundError ex) {
            return null;
        }
    }
}

