/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Closure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.resolver.JavaMethodClosure;
import org.operamasks.el.resources.Resources;

class MultiMethodClosure
extends JavaMethodClosure {
    private transient String name;
    private transient Method[] methods;
    private static final long serialVersionUID = -3244166360202624828L;

    public MultiMethodClosure(String name) {
        this.name = name;
        this.methods = new Method[0];
    }

    public String getName() {
        return this.name;
    }

    protected JavaMethodClosure addMethod(Method method) {
        method.setAccessible(true);
        Method[] newlist = new Method[this.methods.length + 1];
        System.arraycopy(this.methods, 0, newlist, 0, this.methods.length);
        newlist[this.methods.length] = method;
        this.methods = newlist;
        return this;
    }

    public int arity(ELContext elctx) {
        int arity = 0;
        for (Method m : this.methods) {
            int n = m.getParameterTypes().length;
            if (n <= arity) continue;
            arity = n;
        }
        return arity;
    }

    public MethodInfo getMethodInfo(ELContext elctx) {
        return new MethodInfo(this.methods[0].getName(), this.methods[0].getReturnType(), (Class[])this.methods[0].getParameterTypes());
    }

    public int getModifiers() {
        return this.methods[0].getModifiers();
    }

    public Object invoke(ELContext elctx, Object base, Closure[] args) {
        Method method = ELEngine.resolveMethod(elctx, this.methods, this.name, args);
        if (method == null) {
            String clsname = this.methods[0].getDeclaringClass().getName();
            throw new MethodNotFoundException(Resources._T("EL_FN_NO_SUCH_METHOD", this.name, this.name, clsname));
        }
        return ELEngine.invokeMethod(elctx, base, method, args);
    }

    public Object invokeSuper(ELContext elctx, Object base, Closure[] args) {
        Method method = ELEngine.resolveMethod(elctx, this.methods, this.name, args);
        if (method == null) {
            String clsname = this.methods[0].getDeclaringClass().getName();
            throw new MethodNotFoundException(Resources._T("EL_FN_NO_SUCH_METHOD", this.name, this.name, clsname));
        }
        return MultiMethodClosure.invokeSuper(elctx, method, base, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MultiMethodClosure) {
            MultiMethodClosure that = (MultiMethodClosure)((Object)o);
            return this.name.equals(that.name) && Arrays.equals(this.methods, that.methods);
        }
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        for (Method method : this.methods) {
            result = 31 * result + method.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("#<primitive:");
        buf.append(this.name);
        buf.append("[");
        for (int i = 0; i < this.methods.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.methods[i].toString());
        }
        buf.append("]>");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.writeUTF(this.name);
        out.writeInt(this.methods.length);
        for (Method method : this.methods) {
            MultiMethodClosure.writeMethod(out, method);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        int count = in.readInt();
        this.methods = new Method[count];
        for (int i = 0; i < count; ++i) {
            this.methods[i] = MultiMethodClosure.readMethod(in);
            this.methods[i].setAccessible(true);
        }
    }
}

