/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Closure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.resolver.JavaMethodClosure;
import org.operamasks.el.resolver.MultiMethodClosure;
import org.operamasks.el.resources.Resources;

class SingleMethodClosure
extends JavaMethodClosure {
    private transient Method method;
    private transient int nargs;
    private transient boolean vargs;

    public SingleMethodClosure(Method method) {
        this.method = method;
        this.init(method);
    }

    public String getName() {
        return this.method.getName();
    }

    protected JavaMethodClosure addMethod(Method method) {
        MultiMethodClosure closure = new MultiMethodClosure(this.getName());
        ((JavaMethodClosure)closure).addMethod(this.method);
        ((JavaMethodClosure)closure).addMethod(method);
        return closure;
    }

    public int arity(ELContext elctx) {
        return this.nargs;
    }

    public MethodInfo getMethodInfo(ELContext elctx) {
        return new MethodInfo(this.method.getName(), this.method.getReturnType(), (Class[])this.method.getParameterTypes());
    }

    public int getModifiers() {
        return this.method.getModifiers();
    }

    public Object invoke(ELContext elctx, Object base, Closure[] args) {
        if (!(this.nargs == args.length || this.vargs && args.length >= this.nargs - 1)) {
            throw new ELException(Resources._T("EL_FN_BAD_ARG_COUNT", this.getName(), this.nargs, args.length));
        }
        return ELEngine.invokeMethod(elctx, base, this.method, args);
    }

    public Object invokeSuper(ELContext elctx, Object base, Closure[] args) {
        if (!(this.nargs == args.length || this.vargs && args.length >= this.nargs - 1)) {
            throw new ELException(Resources._T("EL_FN_BAD_ARG_COUNT", this.getName(), this.nargs, args.length));
        }
        return SingleMethodClosure.invokeSuper(elctx, this.method, base, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SingleMethodClosure) {
            SingleMethodClosure that = (SingleMethodClosure)((Object)o);
            return this.method.equals(that.method);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return "#<primitive:" + this.method.getName() + "[" + this.method + "]>";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SingleMethodClosure.writeMethod(out, this.method);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.method = SingleMethodClosure.readMethod(in);
        this.init(this.method);
    }

    private void init(Method method) {
        method.setAccessible(true);
        Class<?>[] types = method.getParameterTypes();
        this.nargs = types.length;
        if (this.nargs > 0 && types[0] == ELContext.class) {
            --this.nargs;
        }
        this.vargs = method.isVarArgs();
    }
}

