/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.operamasks.org.objectweb.asm.Attribute;
import org.operamasks.org.objectweb.asm.ByteVector;
import org.operamasks.org.objectweb.asm.ClassReader;
import org.operamasks.org.objectweb.asm.ClassWriter;
import org.operamasks.org.objectweb.asm.Label;
import org.operamasks.org.objectweb.asm.attrs.LocalVariableType;

public class LocalVariableTypeTableAttribute
extends Attribute {
    protected List types = new ArrayList();

    public LocalVariableTypeTableAttribute() {
        super("LocalVariableTypeTable");
    }

    public List getTypes() {
        return this.types;
    }

    protected Label[] getLabels() {
        HashSet<Label> labels = new HashSet<Label>();
        for (int i = 0; i < this.types.size(); ++i) {
            LocalVariableType t = (LocalVariableType)this.types.get(i);
            labels.add(t.getStart());
            labels.add(t.getEnd());
        }
        return labels.toArray(new Label[labels.size()]);
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        int localVariableTypeTableLength = cr.readUnsignedShort(off);
        off += 2;
        LocalVariableTypeTableAttribute attr = new LocalVariableTypeTableAttribute();
        for (int i = 0; i < localVariableTypeTableLength; ++i) {
            LocalVariableType t = new LocalVariableType();
            int start = cr.readUnsignedShort(off);
            int length = cr.readUnsignedShort(off + 2);
            t.start = this.getLabel(labels, start);
            t.end = this.getLabel(labels, start + length);
            t.name = cr.readUTF8(off + 4, buf);
            t.signature = cr.readUTF8(off + 6, buf);
            t.index = cr.readUnsignedShort(off + 8);
            off += 10;
            this.types.add(t);
        }
        return attr;
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        bv.putShort(this.types.size());
        for (int i = 0; i < this.types.size(); ++i) {
            LocalVariableType t = (LocalVariableType)this.types.get(i);
            int startOffset = t.getStart().getOffset();
            bv.putShort(startOffset);
            bv.putShort(t.getEnd().getOffset() - startOffset);
            bv.putUTF8(t.getName());
            bv.putUTF8(t.getSignature());
            bv.putShort(t.getIndex());
        }
        return bv;
    }

    private Label getLabel(Label[] labels, int offset) {
        Label label = labels[offset];
        if (label == null) {
            labels[offset] = label = new Label();
        }
        return label;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LocalVariableTypeTable[");
        for (int i = 0; i < this.types.size(); ++i) {
            sb.append('\n').append('[').append(this.types.get(i)).append(']');
        }
        sb.append("\n]");
        return sb.toString();
    }
}

