/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.objectweb.asm.tree;

import org.operamasks.org.objectweb.asm.Attribute;
import org.operamasks.org.objectweb.asm.CodeAdapter;
import org.operamasks.org.objectweb.asm.Label;
import org.operamasks.org.objectweb.asm.tree.FieldInsnNode;
import org.operamasks.org.objectweb.asm.tree.IincInsnNode;
import org.operamasks.org.objectweb.asm.tree.InsnNode;
import org.operamasks.org.objectweb.asm.tree.IntInsnNode;
import org.operamasks.org.objectweb.asm.tree.JumpInsnNode;
import org.operamasks.org.objectweb.asm.tree.LdcInsnNode;
import org.operamasks.org.objectweb.asm.tree.LineNumberNode;
import org.operamasks.org.objectweb.asm.tree.LocalVariableNode;
import org.operamasks.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.operamasks.org.objectweb.asm.tree.MethodInsnNode;
import org.operamasks.org.objectweb.asm.tree.MethodNode;
import org.operamasks.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.operamasks.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.operamasks.org.objectweb.asm.tree.TryCatchBlockNode;
import org.operamasks.org.objectweb.asm.tree.TypeInsnNode;
import org.operamasks.org.objectweb.asm.tree.VarInsnNode;

public class TreeCodeAdapter
extends CodeAdapter {
    public MethodNode methodNode;

    public TreeCodeAdapter(MethodNode methodNode) {
        super(null);
        this.methodNode = methodNode;
    }

    public void visitInsn(int opcode) {
        InsnNode n = new InsnNode(opcode);
        this.methodNode.instructions.add(n);
    }

    public void visitIntInsn(int opcode, int operand) {
        IntInsnNode n = new IntInsnNode(opcode, operand);
        this.methodNode.instructions.add(n);
    }

    public void visitVarInsn(int opcode, int var) {
        VarInsnNode n = new VarInsnNode(opcode, var);
        this.methodNode.instructions.add(n);
    }

    public void visitTypeInsn(int opcode, String desc) {
        TypeInsnNode n = new TypeInsnNode(opcode, desc);
        this.methodNode.instructions.add(n);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        FieldInsnNode n = new FieldInsnNode(opcode, owner, name, desc);
        this.methodNode.instructions.add(n);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        MethodInsnNode n = new MethodInsnNode(opcode, owner, name, desc);
        this.methodNode.instructions.add(n);
    }

    public void visitJumpInsn(int opcode, Label label) {
        JumpInsnNode n = new JumpInsnNode(opcode, label);
        this.methodNode.instructions.add(n);
    }

    public void visitLabel(Label label) {
        this.methodNode.instructions.add(label);
    }

    public void visitLdcInsn(Object cst) {
        LdcInsnNode n = new LdcInsnNode(cst);
        this.methodNode.instructions.add(n);
    }

    public void visitIincInsn(int var, int increment) {
        IincInsnNode n = new IincInsnNode(var, increment);
        this.methodNode.instructions.add(n);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        TableSwitchInsnNode n = new TableSwitchInsnNode(min, max, dflt, labels);
        this.methodNode.instructions.add(n);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        LookupSwitchInsnNode n = new LookupSwitchInsnNode(dflt, keys, labels);
        this.methodNode.instructions.add(n);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        MultiANewArrayInsnNode n = new MultiANewArrayInsnNode(desc, dims);
        this.methodNode.instructions.add(n);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        TryCatchBlockNode n = new TryCatchBlockNode(start, end, handler, type);
        this.methodNode.tryCatchBlocks.add(n);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.methodNode.maxStack = maxStack;
        this.methodNode.maxLocals = maxLocals;
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        LocalVariableNode n = new LocalVariableNode(name, desc, start, end, index);
        this.methodNode.localVariables.add(n);
    }

    public void visitLineNumber(int line, Label start) {
        LineNumberNode n = new LineNumberNode(line, start);
        this.methodNode.lineNumbers.add(n);
    }

    public void visitAttribute(Attribute attr) {
        attr.next = this.methodNode.codeAttrs;
        this.methodNode.codeAttrs = attr;
    }
}

